package com.rv.share.fragment;

import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.widget.LinearLayout;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.google.gson.Gson;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.share.R;
import com.rv.share.R2;
import com.rv.share.adapter.InviteListAdapter;
import com.rv.share.bean.InviteListBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;

public class InviteFragment extends BaseFragment<CommonPresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout refreshLayout;

    private InviteListAdapter adapter;

    private int currentPage = 1;
    private int pageSize = 10;
    private int pageTotal = 0;
    private long failureTime;

    public static InviteFragment getInstance() {
        InviteFragment fragment = new InviteFragment();
        return fragment;
    }

    @Override
    public int getViewLayout() {
        return R.layout.fragment_income_record;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext(), LinearLayout.VERTICAL, false));
        adapter = new InviteListAdapter(new ArrayList<InviteListBean.inviteMember>());
        adapter.setOnLoadMoreListener(this, recyclerView);
        refreshLayout.setHeaderView(new SimpleRefreshView(getContext()));
        refreshLayout.setOnSimpleRefreshListener(this);
        recyclerView.setAdapter(adapter);
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {
        getInviteData();
    }


    @Override
    public void onShowResult(int requestType, BaseBean result) {
        if (requestType == 0) {
            InviteListBean bean = (InviteListBean) result;
            if (bean.isRel() && bean.getData() != null && bean.getData().getInviteMembers() != null) {
                if (currentPage == 1) {
                    failureTime = bean.getData().getFailureTime();
                    pageTotal = bean.getData().getTotalPage();
                    refreshLayout.onRefreshComplete();
                    if (bean.getData().getInviteMembers().size() == 0) {
                        adapter.setEmptyView(getEmptyView(recyclerView, -1, getString(R.string.rv_select_not_data)));
                        adapter.notifyDataSetChanged();
                    } else {
                        adapter.setEffTime(failureTime * 1000);
                        adapter.setNewData(bean.getData().getInviteMembers());
                    }
                } else {
                    adapter.addData(bean.getData().getInviteMembers());
                    adapter.loadMoreComplete();
                }
            }
        }
    }
//
//    private void getInviteData() {
//        String result = "{\"status\":200,\"message\":\"Success\",\"data\":{\"failureTime\":5184000,\"inviteMembers\":[ {\n" +
//                "        \"username\": \"15814005696\",\n" +
//                "        \"headUrl\": \"https://xxtest.upyuns.com/image/app/default_%20avatar.png\",\n" +
//                "        \"joinTime\": 1562402775992,\n" +
//                "        \"bindTime\": 1562402775992\n" +
//                "      },\n" +
//                "      {\n" +
//                "        \"username\": \"18552854696\",\n" +
//                "        \"headUrl\": \"https://xxtest.upyuns.com/image/app/default_%20avatar.png\",\n" +
//                "        \"joinTime\": 1563346993152,\n" +
//                "        \"bindTime\": 1563346993152\n" +
//                "      },\n" +
//                "      {\n" +
//                "        \"username\": \"17612025866\",\n" +
//                "        \"headUrl\": \"http://thirdwx.qlogo.cn/mmopen/vi_32/IEiawcHX9Y3HpqxALj6cFL7WSc8UxH7BDIHUf9gthntPdM7Ly0xnZ6sVpXic281kPb1w3oTHVbosTjc7z7Ef7naQ/132\",\n" +
//                "        \"joinTime\": 1563346993152,\n" +
//                "        \"bindTime\": 1563346993152\n" +
//                "      }],\"page\":1,\"limit\":10},\"rel\":true}";
//        InviteListBean bean = new Gson().fromJson(result, InviteListBean.class);
//        onShowResult(0, bean);
//    }

    private void getInviteData() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());

            Map<String, Object> map = new HashMap<>();
            map.put("state", 2);
            map.put("page", currentPage);
            map.put("limit", pageSize);
            mPresenter.getData(RvFrameConfig.HOST, 0, ApiConfig.HTTP_URL_INVITE_LIST, InviteListBean.class, map, header, true);
        }

    }

    @Override
    public void onLoadMoreRequested() {

        if (currentPage >= pageTotal) {
            adapter.loadMoreEnd();
        } else {
            currentPage++;
            getInviteData();
        }
    }

    @Override
    public void onRefresh() {
        currentPage = 1;
        getInviteData();
    }
}
