package com.rv.share.adapter;

import android.support.annotation.Nullable;

import com.base.utils.ui.image.round.RoundImageView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.component.utils.DateUtils;
import com.rv.share.R;
import com.rv.share.bean.InviteListBean;

import java.util.List;

public class ActivationListAdapter extends BaseQuickAdapter<InviteListBean.inviteMember, BaseViewHolder> {

    public ActivationListAdapter(@Nullable List<InviteListBean.inviteMember> data) {
        super(R.layout.item_activation, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, InviteListBean.inviteMember item) {
        helper.setText(R.id.tv_name, item.getUsername());
        helper.setText(R.id.tv_ac_time, DateUtils.timestampToString1(item.getBindTime()));

        GlideManager.getInstance(mContext).loadImage(item.getHeadUrl(), (RoundImageView) helper.itemView.findViewById(R.id.rimg_header));
    }
}
