package com.rv.points.adapter;

import android.graphics.Color;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.rv.points.R;
import com.rv.points.bean.PointBean;

import java.util.List;

public class PointAdapter extends BaseQuickAdapter<PointBean.RvPointItem, BaseViewHolder> {

    public PointAdapter(List<PointBean.RvPointItem> lists) {
        super(R.layout.item_point, lists);
    }

    @Override
    protected void convert(BaseViewHolder helper, PointBean.RvPointItem item) {
        if (!TextUtils.isEmpty(item.getImg())) {
            GlideManager.getInstance(mContext).loadImage(item.getImg(), (ImageView) helper.itemView.findViewById(R.id.img_icon));
        }
        if (!TextUtils.isEmpty(item.getName())) {
            helper.setText(R.id.tv_name, item.getName());
        }
        if (!TextUtils.isEmpty(item.getRegulation())) {
            if ("SIGN".equals(item.getCode())) {
                helper.setText(R.id.tv_regulation, "签到规则");
                helper.setTextColor(R.id.tv_regulation, Color.parseColor("#FFB74B"));
                helper.addOnClickListener(R.id.tv_regulation);
            } else {
                helper.setText(R.id.tv_regulation, item.getRegulation());
                helper.setTextColor(R.id.tv_regulation, Color.parseColor("#999999"));
            }
        }
        if (item.getPoint() != 0) {
            helper.setText(R.id.tv_points, item.getPoint() + "分");
        }
        if (!TextUtils.isEmpty(item.getBtnWord())) {
            helper.setText(R.id.btn_state, item.getBtnWord());
        }
        helper.setBackgroundRes(R.id.btn_state, item.isIntegralStatus() ? R.drawable.shape_rv_bg_member_top_grap : R.drawable.shape_rv_bg_dark_yellow);
        if (item.isIntegralStatus()) {
            helper.itemView.findViewById(R.id.btn_state).setEnabled(false);
        } else {
            helper.itemView.findViewById(R.id.btn_state).setEnabled(true);
        }
        helper.addOnClickListener(R.id.btn_state);
    }
}
