package com.xxrv.coupon.fragment;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.xxrv.coupon.R;
import com.xxrv.coupon.R2;
import com.xxrv.coupon.adapter.WaitCouponAdapter;
import com.xxrv.coupon.api.CouponApi;
import com.xxrv.coupon.bean.CouponBean;
import com.xxrv.coupon.presenter.CouponAllPresenter;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;
import butterknife.BindView;

/**
 * 优惠券  待使用
 */

public class WaitCouponFragment extends BaseFragment<CouponAllPresenter> implements SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout mSimpleRefreshLayout;

    WaitCouponAdapter mAdapter;

    
    public static WaitCouponFragment getInstance(int type) {
        Bundle bundl = new Bundle();
        bundl.putInt("type", type);
        WaitCouponFragment fragment = new WaitCouponFragment();
        fragment.setArguments(bundl);
        return fragment;
    }

    @Override
    public int getViewLayout() {
        return R.layout.fragment_coupon_wait;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        mSimpleRefreshLayout.setHeaderView(new SimpleRefreshView(_mActivity));
        mSimpleRefreshLayout.setOnSimpleRefreshListener(this);

        mAdapter = new WaitCouponAdapter();
        rvContent.setLayoutManager(new LinearLayoutManager(_mActivity, LinearLayoutManager.VERTICAL, false));
        rvContent.setAdapter(mAdapter);

    }

    @Override
    protected void loadData(Bundle savedInstanceState) {
        geDataList();
    }

    /**
     * 请求数据
     */
    private void geDataList() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("type", "0");
        mPresenter.getData(RvFrameConfig.HOST,0, CouponApi.HTTP_URL_COUPON_LIST, CouponBean.class, map,headMap,false);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        mSimpleRefreshLayout.onRefreshComplete();
        processData((CouponBean) result);
    }

    private void processData(CouponBean bean) {
        mAdapter.getData().clear();
            mAdapter.addData(bean.getData());
    }

    @Override
    public void onRefresh() {
        geDataList();
    }
}
