package com.xxrv.coupon;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.fastjson.JSON;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.xxrv.coupon.adapter.CarCouponAdapter;
import com.xxrv.coupon.bean.CouponBean;
import com.xxrv.coupon.presenter.CouponAllPresenter;

import java.util.List;

import butterknife.BindView;

/**
 * 租车优惠券
 */
@Route(path = Constance.ACTIVITY_URL_CARCOUPON)
public class CarCouponActivity extends BaseStatusActivity<CouponAllPresenter> {
    @BindView(R2.id.rv_content)
    RecyclerView rvContent;

    private CarCouponAdapter mAdapter;

    @Autowired()
    String coupon;


    @Override
    protected int setLayout() {
        return R.layout.activity_car_coupon;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("优惠券");

        mAdapter = new CarCouponAdapter();
        rvContent.setLayoutManager(new LinearLayoutManager(mActivity, LinearLayoutManager.VERTICAL, false));
        rvContent.setAdapter(mAdapter);

        if (coupon != null) {
            List<CouponBean.DataBean> couponBeans = JSON.parseArray(coupon, CouponBean.DataBean.class);
            mAdapter.addData(couponBeans);
        }

        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                CouponBean.DataBean item = (CouponBean.DataBean) adapter.getItem(position);
                if ("1".equals(item.getStatus())) {
                    getIntent().putExtra("position", position);
                    setResult(RESULT_OK, getIntent());
                    finish();
                }
            }
        });

    }


    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    private void processData(CouponBean bean) {
    }

}
