package com.rv.home.rv.module.ui.main.home.order;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.util.TimeManager;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.ZxingUtils;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.home.rv.module.basic.presenter.PickerPresenter;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;

import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 取车二维码
 */
public class PickUpTheCarQRCodeActivity extends BaseStatusActivity<PickerPresenter> {

    @BindView(R2.id.tv_center)
    TextView tvCenter;
    @BindView(R2.id.lay_title)
    RelativeLayout layTitle;
    @BindView(R2.id.iv_goods)
    ImageView ivGoods;
    @BindView(R2.id.tv_car_type)
    TextView tvCarType;
    @BindView(R2.id.tv_get_time)
    TextView tvGetTime;
    @BindView(R2.id.tv_get_address)
    TextView tvGetAddress;
    @BindView(R2.id.ll_get)
    LinearLayout llGet;
    @BindView(R2.id.tv_out_time)
    TextView tvOutTime;
    @BindView(R2.id.tv_out_address)
    TextView tvOutAddress;
    @BindView(R2.id.ll_out)
    LinearLayout llOut;
    @BindView(R2.id.tv_price)
    TextView tvPrice;
    @BindView(R2.id.iv_zxing)
    ImageView ivZxing;

    private OrderListBean.DataBeanX.DataBean dataBean;


    public static Intent getIntent(Context context, OrderListBean.DataBeanX.DataBean dataBean) {
        return new Intent(context, PickUpTheCarQRCodeActivity.class)
                .putExtra("dataBean", dataBean);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_pick_up_the_car_qrcode;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);
        dataBean = (OrderListBean.DataBeanX.DataBean) intent.getSerializableExtra("dataBean");

        if (dataBean != null) {
            if (4 == dataBean.getStatusX()) {
                tvCenter.setText("出示取车二维码");
            } else if (5 == dataBean.getStatusX()) {
                tvCenter.setText("出示还车二维码");
            }
            tvCarType.setText(dataBean.getName());
            OrderListBean.DataBeanX.DataBean.OrderRentVehicleDetail detail = dataBean.getOrderRentVehicleDetail();
            if (detail != null) {
                tvGetAddress.setText(detail.getStart_addr());
                tvGetTime.setText(TimeManager.stampToDate(String.valueOf(detail.getStart_time())));
                tvOutAddress.setText(detail.getEnd_addr());
                tvOutTime.setText(TimeManager.stampToDate(String.valueOf(detail.getEnd_time())));
                tvPrice.setText(String.format("¥%1$s", dataBean.getRealAmount()));
                GlideManager.getInstance(mActivity).loadImage(dataBean.getIcon(), ivGoods);
            }
        }

        //生成带中间图标的二维码
        Bitmap success = ZxingUtils.createQRImage(dataBean.getQrcodeStr(), 100, 100,
                BitmapFactory.decodeResource(getResources(), R.mipmap.ic_launcher));
        ivZxing.setImageBitmap(success);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // TODO: add setContentView(...) invocation
        ButterKnife.bind(this);
    }

    @OnClick({R2.id.iv_back, R2.id.iv_customer_service})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.iv_back) {
            finish();
        } else if (id == R.id.iv_customer_service) {
            showToast("该功能还在开发中...");
        }
    }
}
