package com.rv.component.utils;


import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 时间Util
 */
public class DateUtils {

    /**
     * yyyy-MM-dd HH:mm:ss
     */
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    /**
     * yyMMddHHmm
     */
    private static SimpleDateFormat sdf2 = new SimpleDateFormat("yyMMddHHmm");
    /**
     * yyMMddHHmmss
     */
    private static SimpleDateFormat sdf3 = new SimpleDateFormat("yyMMddHHmmss");
    /**
     * yyyy-MM-dd HH:mm:ss:SS
     */
    private static SimpleDateFormat hmf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
    /**
     * yyyy-MM-dd
     */
    private static SimpleDateFormat sdf4 = new SimpleDateFormat("yyyy-MM-dd");
    /**
     * MM-dd
     */
    private static SimpleDateFormat sdf5 = new SimpleDateFormat("MM-dd");

    /**
     * MM-dd HH:mm
     */
    private static SimpleDateFormat sdf6 = new SimpleDateFormat("MM-dd HH:mm");

    /**
     * yyyy-MM-dd HH:mm
     */
    private static SimpleDateFormat sdf7 = new SimpleDateFormat("yyyy-MM-dd HH:mm");


    /**
     * yyyy-MM
     */
    private static SimpleDateFormat sdf8 = new SimpleDateFormat("yyyy-MM");

    /**
     * yyyy年MM月
     */
    private static SimpleDateFormat sdf9 = new SimpleDateFormat("yyyy年MM月");

    /**
     * yyyy年MM月dd日
     */
    private static SimpleDateFormat sdf10 = new SimpleDateFormat("yyyy年MM月dd日");

    /**
     * yy-MM-dd
     */
    private static SimpleDateFormat sdf11 = new SimpleDateFormat("yyyy-MM-dd");

    /**
     * HH:mm
     */
    private static SimpleDateFormat sdf12 = new SimpleDateFormat("HH:mm");


    /**
     * yy-MM-dd HH:mm
     */
    private static SimpleDateFormat sdf13 = new SimpleDateFormat("yy-MM-dd HH:mm");

    /**
     * HH
     */
    private static SimpleDateFormat sdf14 = new SimpleDateFormat("HH");

    /**
     * mm
     */
    private static SimpleDateFormat sdf15 = new SimpleDateFormat("mm");


    /**
     * dd
     */
    private static SimpleDateFormat sdf16 = new SimpleDateFormat("dd");

    /**
     * 将yyyy-MM-dd HH:mm:ss转换 Date
     *
     * @param time yyyy-MM-dd HH:mm:ss
     * @return
     */
    public static Date StringToDate(String time) {
        Date date = null;
        try {
            date = sdf.parse(time);
        } catch (ParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return date;

    }

    /**
     * 将 yyyy-MM-dd 转换成 Date
     *
     * @param time yyyy-MM-dd
     * @return
     */
    public static Date StringToDate2(String time) {
        Date date = null;
        try {
            date = sdf4.parse(time);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;

    }

    /**
     * 将字符串时间转换为时间戳
     *
     * @param time yyyy-MM-dd HH:mm:ss
     * @return 错误则返回0
     */
    public static long StringToTimeMillis(String time) {
        long tm = 0;
        try {
            tm = sdf.parse(time).getTime();
        } catch (ParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return tm;
    }

    public static long StringToTimeMillis2(String time) {
        long tm = 0;
        try {
            tm = sdf7.parse(time).getTime();
        } catch (ParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return tm;
    }

    /**
     * 将时间戳转换成yyyy-MM-dd HH:mm:ss字符串
     *
     * @param time 时间戳
     * @return yyyy-MM-dd HH:mm:ss
     */
    public static String timestampToString(long time) {
        return sdf.format(new Date(time));
    }

    /**
     * 将时间戳转换成yyyy-MM-dd HH:mm字符串
     *
     * @param time 时间戳
     * @return yyyy-MM-dd HH:mm
     */
    public static String timestampToString1(long time) {
        return sdf7.format(new Date(time));
    }

    /**
     * 将时间戳转换成yyyy-MM-dd字符串
     *
     * @param time 时间戳
     * @return yyyy-MM-dd
     */
    public static String timestampToString2(long time) {
        return sdf4.format(new Date(time));
    }


    /**
     * 获取手机当前时间戳毫秒
     *
     * @return
     */
    public static long getCurTimeMillis() {
        return System.currentTimeMillis();
    }

    /**
     * 获取系统当前时间，返回 yyyy-MM-dd HH:mm:ss
     *
     * @return yyyy-MM-dd HH:mm:ss
     */
    public static String getCurDateTime() {
        String time = "";
        time = timestampToString(System.currentTimeMillis());
        return time;
    }

    /**
     * 获取当前日期
     *
     * @return yyyy-MM-dd
     */
    public static String getCurDate() {
        String time = "";
        time = sdf4.format(new Date(System.currentTimeMillis()));
        return time;
    }

    /**
     * 比较两个时间相差多少秒 datetime1-datetime2
     *
     * @param datetime1 sdf3
     * @param datetime2 sdf3
     * @return 失败返回-1 ，所以尽量是datetime1大于datetime2
     */
    public static long compareDateSecond2(String datetime1, String datetime2) {
        String date1=formatDate7(datetime1);
        String date2=formatDate7(datetime2);
        return compareDateSecond(date1,date2);
    }

    /**
     * 比较两个时间相差多少秒 datetime1-datetime2
     *
     * @param datetime1 yyyy-MM-dd HH:mm:ss
     * @param datetime2 yyyy-MM-dd HH:mm:ss
     * @return 失败返回-1 ，所以尽量是datetime1大于datetime2
     */
    public static long compareDateSecond(String datetime1, String datetime2) {
        try {
            Date date1 = sdf.parse(datetime1);
            Date date2 = sdf.parse(datetime2);
            return compareDateSecond(date1.getTime(), date2.getTime());
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 比较两个时间相差多少秒 datetime1-datetime2
     *
     * @param datetime1
     * @param datetime2
     * @return 失败返回-1 ，所以尽量是datetime1大于datetime2
     */
    public static long compareDateSecond(long datetime1, long datetime2) {
        long diff = -1;
        try {
            long diffTime = datetime1 - datetime2;
            diff = diffTime / 1000;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return diff;
    }

    /**
     * 比较两个时间相差多少天 datetime1-datetime2
     *
     * @param datetime1
     * @param datetime2
     * @return 失败返回-1 ，所以尽量是datetime1大于datetime2
     */
    public static long compareDateDay(String datetime1, String datetime2) {
        try {
            Date date1 = sdf4.parse(datetime1);
            Date date2 = sdf4.parse(datetime2);
            return compareDateDay(date1.getTime(), date2.getTime());
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /**
     * 比较两个时间相差多少天 datetime1-datetime2
     *
     * @param datetime1
     * @param datetime2
     * @return 失败返回-1 ，所以尽量是datetime1大于datetime2
     */
    public static long compareDateDay(long datetime1, long datetime2) {
        long diff = -1;
        try {
            long diffTime = datetime1 - datetime2;
            diff = diffTime / (1000 * 60 * 60 * 24);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return diff;
    }

    /**
     * 在指定时间上添加多少年、月、日
     *
     * @param date    yyyy-MM-dd
     * @param addType Calendar.YEAR 、 Calendar.MONTH 、 Calendar.DATE
     * @param addNum
     * @return yyyy-MM-dd
     */
    public static String addDate(String date, int addType, int addNum) {
        String time = "";
        try {
            Date temp_date = sdf4.parse(date);
            Date temp_date2 = addDate(temp_date, addType, addNum);
            time = sdf4.format(temp_date2);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }

    /**
     * 在指定时间上添加多少年、月、日
     *
     * @param date    yyyy-MM-dd
     * @param addType Calendar.YEAR 、 Calendar.MONTH 、 Calendar.DATE
     * @param addNum
     * @return yyyy-MM-dd
     */
    public static Date addDate(Date date, int addType, int addNum) {
        Date tempDate = null;
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(addType, addNum);
            tempDate = cal.getTime();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return tempDate;
    }

    /**
     * 将yyyy-MM-dd格式成MM-dd
     *
     * @param dateStr yyyy-MM-dd
     * @return MM-dd
     */
    public static String formatDate(String dateStr) {
        String day = "";
        try {
            Date date = sdf4.parse(dateStr);
            day = sdf5.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    /**
     * 将yyyy-MM-dd HH:mm:ss格式成yyMMddHHmmss
     *
     * @param dateStr yyyy-MM-dd HH:mm:ss
     * @return yyMMddHHmm
     */
    public static String formatDate2(String dateStr) {
        String day = "";
        try {
            Date date = sdf.parse(dateStr);
            day = sdf2.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    /**
     * 将yyyy-MM-dd HH:mm:ss格式成yyyy-MM-dd HH:mm
     *
     * @param dateStr yyyy-MM-dd HH:mm:ss
     * @return yyyy-MM-dd HH:mm
     */
    public static String formatDate8(String dateStr) {
        String day = "";
        try {
            Date date = sdf.parse(dateStr);
            day = sdf7.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    /**
     * 将yyyy-MM-dd HH:mm:ss格式成yyyy-MM
     *
     * @param dateStr yyyy-MM-dd HH:mm:ss
     * @return yyyy-MM
     */
    public static String formatDate9(String dateStr) {
        String day = "";
        try {
            Date date = sdf.parse(dateStr);
            day = sdf8.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }


    /**
     * yyyy-MM 转化成 yyyy年MM月
     * @param dateStr yyyy-MM
     * @return  yyyy年MM月
     */
    public static String formatDate8To9(String dateStr) {
        String day = "";
        try {
            Date date = sdf8.parse(dateStr);
            day = sdf9.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }


    /**
     * 将yyyy-MM-dd HH:mm:ss格式成MM-dd
     *
     * @param dateStr yyyy-MM-dd HH:mm:ss
     * @return MM-dd
     */
    public static String formatDate11(String dateStr) {
        String day = "";
        try {
            Date date = sdf.parse(dateStr);
            day = sdf5.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    /**
     * 将yyyy-MM-dd格式成yyyy-MM
     *
     * @param dateStr yyyy-MM-dd
     * @return yyyy-MM
     */
    public static String formatDate10(String dateStr) {
        String day = "";
        try {
            Date date = sdf4.parse(dateStr);
            day = sdf8.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    /**
     * 将yyyy-MM-dd格式成yyyy年MM月dd日
     *
     * @param dateStr yyyy-MM-dd
     * @return yyyy年MM月dd日
     */
    public static String formatDate13(String dateStr) {
        String day = "";
        try {
            Date date = sdf4.parse(dateStr);
            day = sdf10.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    /**
     * 将yyyy-MM-dd格式成yy-MM-dd
     *
     * @param dateStr yyyy-MM-dd
     * @return yy-MM-dd
     */
    public static String formatDate15(String dateStr) {
        String day = "";
        try {
            Date date = sdf4.parse(dateStr);
            day = sdf11.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }


    /**
     * 将yyyy-MM-dd HH:mm格式成yyyy-MM-dd
     *
     * @param dateStr yyyy-MM-dd HH:mm
     * @return yyyy-MM-dd
     */
    public static String formatDate16(String dateStr) {
        String day = "";
        try {
            Date date = sdf7.parse(dateStr);
            day = sdf4.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }


    /**
     * 将yyyy-MM-dd HH:mm格式成HH:mm
     *
     * @param dateStr yyyy-MM-dd HH:mm
     * @return HH:mm
     */
    public static String formatDate17(String dateStr) {
        String day = "";
        try {
            Date date = sdf7.parse(dateStr);
            day = sdf12.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }


    /**
     * 将yyyy-MM-dd HH:mm格式成yy-MM-dd HH:mm
     *
     * @param dateStr yyyy-MM-dd HH:mm
     * @return yyyy-MM-dd HH:mm
     */
    public static String formatDate18(String dateStr) {
        String day = "";
        try {
            Date date = sdf7.parse(dateStr);
            day = sdf13.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }


    /**
     * 给时分加30分钟
     */
    public static String formatDate19(String dateStr) {
        String day = "";
        try {
            long time = sdf12.parse(dateStr).getTime();
            time +=30*60*1000;
            Date da = new Date(time);
            day = sdf12.format(da);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }


    /**
     * 把时分转成毫秒
     */
    public static long formatDate20(String dateStr) {
        long time =0;
        try {
           time = sdf12.parse(dateStr).getTime();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }


    /**
     * 将yyyy-MM-dd HH:mm格式成HH
     *
     * @param dateStr yyyy-MM-dd HH:mm
     * @return HH
     */
    public static String formatDate21(String dateStr) {
        String day = "";
        try {
            Date date = sdf7.parse(dateStr);
            day = sdf14.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }


    /**
     * 将yyyy-MM-dd HH:mm格式成mm
     *
     * @param dateStr yyyy-MM-dd HH:mm
     * @return mm
     */
    public static String formatDate22(String dateStr) {
        String day = "";
        try {
            Date date = sdf7.parse(dateStr);
            day = sdf15.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }


    /**
     * 将yyyy-MM-dd格式成dd
     *
     * @param dateStr yyyy-MM-dd
     * @return dd
     */
    public static String formatDate23(String dateStr) {
        String day = "";
        try {
            Date date = sdf4.parse(dateStr);
            day = sdf16.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    /**
     * 将yyyy-MM-dd HH:mm:ss格式成MM-dd
     *
     * @param dateStr yyyy-MM-dd HH:mm:ss
     * @return MM-dd hh:mm
     */
    public static String formatDate6(String dateStr) {
        String day = "";
        try {
            Date date = sdf.parse(dateStr);
            day = sdf6.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }


    /**
     * 将yyyy-MM-dd HH:mm格式成MM-dd
     *
     * @param dateStr yyyy-MM-dd HH:mm
     * @return MM-dd hh:mm
     */
    public static String formatDate66(String dateStr) {
        String day = "";
        try {
            Date date = sdf7.parse(dateStr);
            day = sdf6.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    /**
     * 将yyMMddHHmmss格式成yyyy-MM-dd HH:mm:ss
     *
     * @param dateStr yyMMddHHmmss
     * @return yyyy-MM-dd HH:mm:ss
     */
    public static String formatDate7(String dateStr) {
        String day = "";
        try {
            Date date = sdf3.parse(dateStr);
            day = sdf.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    /**
     * 将日期格式成MM-dd
     *
     * @param date 将日期转换成MM-DD
     * @return MM-dd
     */
    public static String formatDate(Date date) {
        String day = "";
        try {
            day = sdf5.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    /**
     * 将yyyy-MM-dd格式成MM-dd
     *
     * @param dateStr yyyy-MM-dd
     * @return MM-dd
     */
    public static String formatDate5(String dateStr) {
        String day = "";
        try {
            Date date = sdf4.parse(dateStr);
            day = sdf5.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    /**
     * 将日期格式成yyyy-MM-dd
     *
     * @param date 将日期转换成yyyy-MM-dd
     * @return yyyy-MM-dd
     */
    public static String formatDate5(Date date) {
        String day = "";
        try {
            day = sdf4.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }




    /**
     * 获取网络时间
     *
     * @return
     */
    public static String getCurrentWebTime() {
        String webTime = "";
        try {
            java.util.Locale locale = java.util.Locale.CHINA; // 这是获得本地中国时区
            String pattern = "yyMMddHHmmss";// 这是日期格式
            SimpleDateFormat df = new SimpleDateFormat(pattern, locale);// 设定日期格式
            Date date = new Date();
            URL url = new URL("http://www.baidu.com");// 取得资源对象
            java.net.URLConnection uc = url.openConnection();// 生成连接对象
            uc.connect(); // 发出连接
            long ld = uc.getDate(); // 取得网站日期时间
            date = new Date(ld); // 转换为标准时间对象
            String bjTime = df.format(date);
            webTime = bjTime;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return webTime;
    }

    /**
     * 获取手机当前时间yyMMddHHmmss
     * @return
     */
    public static String getPhoneCurTime(){
        String timeStr="";
        try {
            Date date=new Date(System.currentTimeMillis());
            timeStr=sdf3.format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return timeStr;
    }


}
