package com.xxfc.rv;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;

import com.ruiwenliu.wrapper.base.BaseActivity;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.util.UtilsManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.Cooker;
import com.rv.component.utils.LogUtil;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.sh.sdk.shareinstall.ShareInstall;
import com.sh.sdk.shareinstall.listener.AppGetInfoListener;
import com.yuyife.okgo.OkGoUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.concurrent.TimeUnit;

import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

public class WelcomeActivity extends BaseActivity<CommonPresenter> {
    private Disposable mDisposable = null;

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected int setLayout() {
        return R.layout.rv_act_weclome;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);//隐藏菜单栏
        interval();

        LogUtil.d("start");

        ShareInstall.getInstance().getInfo(getIntent(), new AppGetInfoListener() {
            @Override
            public void onGetInfoFinish(String info) {
                // 客户端获取到的参数是json字符串格式
                LogUtil.d("ShareInstall", "info = " + info);
//                info ="{\"from\":\"singlemessage\",\"code\":\"qRj5igja_P0101\"}";
                if (info.contains("code"))
                    try {
                        JSONObject object = new JSONObject(info);
                        String inviteCode = object.optString("code");
                        if (!TextUtils.isEmpty(inviteCode)) {
                            Cooker.save(getApplicationContext(), "code", inviteCode);
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        stopCarousel();
    }

    /**
     * 计时器
     */
    private void interval() {
        mDisposable = Flowable.interval(3, TimeUnit.SECONDS)
                .doOnNext(new Consumer<Long>() {
                    @Override
                    public void accept(@NonNull Long aLong) throws Exception {
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Consumer<Long>() {
                    @Override
                    public void accept(@NonNull Long aLong) throws Exception {
                        if (!TextUtils.isEmpty(UtilsManager.getInstance(mActivity).getSPInstance("city_json").getString("token", ""))) {
                            OkGoUtil.setToken(
                                    UtilsManager.getInstance(mActivity)
                                            .getSPInstance("city_json")
                                            .getString("token", ""));
                        }
                        startActivity(MainActivity.getIntent(mActivity));
                        mDisposable.dispose();
                        finish();
                    }
                });

    }

    /**
     * 停止计时
     */
    public void stopCarousel() {
        if (mDisposable != null && !mDisposable.isDisposed()) {
            mDisposable.dispose();
        }
    }
}
