package com.xxrv.wallet.adapter;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.component.utils.DateUtils;
import com.rv.component.utils.DisplayUtil;
import com.xxrv.wallet.R;
import com.xxrv.wallet.bean.IncomeRecordsBean;
import com.xxrv.wallet.bean.WalletcathListBean;

import java.util.List;

public class WalletCathAdapter extends BaseQuickAdapter<WalletcathListBean.ItemWalletcath, BaseViewHolder> {

    public WalletCathAdapter(@Nullable List<WalletcathListBean.ItemWalletcath> data) {
        super(R.layout.item_commision, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, WalletcathListBean.ItemWalletcath item) {
        helper.setText(R.id.tv_consume_name, "提现" + item.getAmount() + "元");
        helper.setText(R.id.tv_income_time, DateUtils.timestampToString1(item.getCrtTime()));
        if (item.getStauts() == 0) {
            helper.setText(R.id.tv_amount, "审核中");
            helper.setTextColor(R.id.tv_amount, Color.parseColor("#cccccc"));
        } else if (item.getStauts() == 1) {
            helper.setText(R.id.tv_amount, "已到帐");
            helper.setTextColor(R.id.tv_amount, Color.parseColor("#999999"));
        } else if (item.getStauts() == 2) {
            helper.setText(R.id.tv_amount, "审核失败");
            helper.setTextColor(R.id.tv_amount, Color.parseColor("#F25b5b"));
        }
        Drawable drawable = mContext.getResources().getDrawable(R.drawable.common_icon_rig_gray);
        drawable.setBounds(0, 0, DisplayUtil.dip2px(mContext, 8), DisplayUtil.dip2px(mContext, 12));
        ((TextView) helper.itemView.findViewById(R.id.tv_amount)).setCompoundDrawables(null, null, drawable, null);
    }


    private String dealName(String name) {
        if (!TextUtils.isEmpty(name)) {
            if (name.length() == 11) {
                return name.substring(0, 3) + "****" + name.substring(7, name.length());
            }
        }
        return name;
    }
}
