package com.rv.share.presenter;

import android.app.Activity;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.ScrollView;
import android.widget.Toast;

import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.component.utils.ShareUtils;
import com.rv.share.view.ShareChoiceDialog;
import com.umeng.socialize.ShareAction;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.media.UMImage;

import java.io.File;

public class ReativeBillPresenter extends CommonPresenter {

    private ShareChoiceDialog dialog = null;
    private ShareAction shareAction = null;
    private ScrollView view = null;
    private Bitmap bitmap = null;
    private UMImage image = null;

    /*****
     * 保存海报
     * @param view
     */
    public void saveBill(ScrollView view) {
        if (view != null) {
            Bitmap bitmap = ShareUtils.getBitmapByView(view);
            File file = null;
            if (bitmap != null) {
                file = ShareUtils.saveBitmapFile(getPresenterContext(), bitmap);
            }
            if (file != null) {
                Toast.makeText(getPresenterContext(), "海报保存在" + file.getAbsolutePath(), Toast.LENGTH_LONG).show();
            }
        }
    }


    /******
     * 分享
     */
    public void share(ScrollView view) {
        this.view = view;
        if (dialog == null) {
            dialog = new ShareChoiceDialog.Builder(getPresenterContext())
                    .setShareListener(myListener)
                    .setWxVisiable(true)
                    .setWxCVisiable(true)
                    .setQQVisiable(true)
                    .create();
        }
        dialog.show();
    }

    /******
     * 分享文件
     * @param var1
     * @param var2
     */
    private void share(SHARE_MEDIA var1, UMImage var2, String content) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(null);
        }
        shareAction.setPlatform(var1)//传入平台
                .withText(content)
                .withMedia(var2);//分享内容
        shareAction.share();
    }

    private ShareChoiceDialog.ShareListener myListener = new ShareChoiceDialog.ShareListener() {

        private void shareDeal() {
            if (view != null && bitmap == null) {
                bitmap = ShareUtils.getBitmapByView(view);
            }
            File file = null;
            if (bitmap != null) {
                file = ShareUtils.saveBitmapFile(getPresenterContext(), bitmap);
            }
            if (file != null) {
                image = new UMImage(getPresenterContext(), file);//bitmap文件
                UMImage thumb = new UMImage(getPresenterContext(), file);
                image.setThumb(thumb);
                image.compressStyle = UMImage.CompressStyle.SCALE;//大小压缩，默认为大小压缩，适合普通很大的图
                image.compressStyle = UMImage.CompressStyle.QUALITY;//质量压缩，适合长图的分享
                image.compressFormat = Bitmap.CompressFormat.PNG;
            }
        }

        @Override
        public void copyShare() {

        }

        @Override
        public void wxShare() {
            if (image == null) {
                shareDeal();
            }
            if (image != null) {
                share(SHARE_MEDIA.WEIXIN, image, "");
            }
        }

        @Override
        public void wxCShare() {

            if (image == null) {
                shareDeal();
            }
            if (image != null) {
                share(SHARE_MEDIA.WEIXIN_CIRCLE, image, "");
            }
        }

        @Override
        public void qqShare() {

        }

        @Override
        public void billShare() {

        }

        @Override
        public void close() {
        }
    };

//    @Override
//    public void detachView() {
//        super.detachView();
//        if (bitmap != null) {
//            bitmap.recycle();
//        }
//    }
}
