package com.rv.share;

import android.content.Context;
import android.content.Intent;

import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.share.adapter.PopularizeListAdapter;
import com.rv.share.bean.PopularizeBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;

public class PopularizeActivity extends BaseStatusActivity<CommonPresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;

    @BindView(R2.id.refresh)
    SimpleRefreshLayout refresh;

    private PopularizeListAdapter listAdapter;

    private int currentPage = 1;
    private int pageSize = 10;
    private int pageTotal = 0;

    public static Intent getIntent(Context context) {
        Intent intent = new Intent(context, PopularizeActivity.class);
        return intent;
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_popularize;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("我的推广");
        recyclerView.setLayoutManager(new LinearLayoutManager(mActivity));
        listAdapter = new PopularizeListAdapter(new ArrayList<PopularizeBean.PopularizeItem>());
        refresh.setHeaderView(new SimpleRefreshView(this));
        refresh.setOnSimpleRefreshListener(this);
        recyclerView.setAdapter(listAdapter);
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);

        getData();
    }

    private void getData() {

        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());

            Map<String, Object> map = new HashMap<>();
            map.put("pageNo", currentPage);
            map.put("pageSize", pageSize);
            mPresenter.getData(RvFrameConfig.HOST, 0, ApiConfig.HTTP_URL_GROUP_INCOME, PopularizeBean.class, map, header, true);
        }
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        if (requestType == 0) {
            PopularizeBean bean = (PopularizeBean) result;
            if (bean.isRel() && bean.getData() != null && bean.getData().getUserTeamMemberBos() != null) {
                if (currentPage == 1) {
                    pageTotal = bean.getData().getPageNum();
                    refresh.onRefreshComplete();
                    if (bean.getData().getUserTeamMemberBos().size() == 0) {
                        listAdapter.setEmptyView(getEmptyView(recyclerView, -1, getString(R.string.rv_select_not_data)));
                        listAdapter.notifyDataSetChanged();
                    } else {
                        listAdapter.setNewData(bean.getData().getUserTeamMemberBos());
                    }
                } else {
                    listAdapter.addData(bean.getData().getUserTeamMemberBos());
                    listAdapter.loadMoreComplete();
                }
            }
        }
    }

    @Override
    public void onLoadMoreRequested() {
        if (currentPage >= pageTotal) {
            listAdapter.loadMoreEnd();
        } else {
            currentPage++;
            getData();
        }
    }

    @Override
    public void onRefresh() {
        currentPage = 1;
        getData();
    }
}
