package com.rv.points.adapter;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.rv.points.R;
import com.rv.points.bean.PointBean;

import java.util.List;

public class PointAdapter extends RecyclerView.Adapter {

    private Context mContext;
    private List<PointBean.RvPointItem> mLists;
    private OnItemClickListener mListener;

    public PointAdapter(Context context, List<PointBean.RvPointItem> lists) {
        super();
        this.mContext = context;
        this.mLists = lists;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mListener = listener;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.item_point, viewGroup, false);
        return new PointViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
        final PointBean.RvPointItem item = mLists.get(i);
        PointViewHolder holder = (PointViewHolder) viewHolder;
        if (!TextUtils.isEmpty(item.getImg())) {
            GlideManager.getInstance(mContext).loadImage(item.getImg(), holder.imgIcon);
        } else {
            holder.imgIcon.setImageResource(com.ruiwenliu.wrapper.R.drawable.glide_icon_error);
        }

        if (!TextUtils.isEmpty(item.getName())) {
            holder.tvName.setText(item.getName());
        } else {
            holder.tvName.setText("");
        }

        if (!TextUtils.isEmpty(item.getRegulation())) {
            if ("SIGN".equals(item.getCode())) {
                holder.tvRegulation.setText("签到规则");
                holder.tvRegulation.setTextColor(Color.parseColor("#FFB74B"));
                holder.tvRegulation.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        if (mListener != null) {
                            mListener.openSignRuler(item.getCode());
                        }
                    }
                });
            } else {
                holder.tvRegulation.setText(item.getRegulation());
                holder.tvRegulation.setTextColor(Color.parseColor("#999999"));
            }
        } else {
            holder.tvRegulation.setText("");
        }
        if (item.getPoint() != 0) {
            holder.tvPoints.setVisibility(View.VISIBLE);
            holder.tvPoints.setText(item.getPoint() + "分");
        } else {
            holder.tvPoints.setVisibility(View.GONE);
        }
        if (!TextUtils.isEmpty(item.getBtnWord())) {
            holder.btnState.setText(item.getBtnWord());
        }

        if ("SIGN".equals(item.getCode())) {
            holder.btnState.setEnabled(true);
            holder.btnState.setBackgroundResource(R.drawable.shape_rv_bg_dark_yellow);
        } else {
            holder.btnState.setEnabled(!item.isIntegralStatus());
            holder.btnState.setBackgroundResource(item.isIntegralStatus() ? R.drawable.shape_rv_bg_member_top_grap : R.drawable.shape_rv_bg_dark_yellow);
        }
        holder.btnState.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (mListener != null) {
                    mListener.onClick(item);
                }
            }
        });
    }

    @Override
    public int getItemCount() {
        return mLists.size();
    }


    private class PointViewHolder extends RecyclerView.ViewHolder {
        ImageView imgIcon;
        TextView tvName;
        TextView tvPoints;
        TextView tvRegulation;
        Button btnState;

        public PointViewHolder(@NonNull View itemView) {
            super(itemView);
            imgIcon = itemView.findViewById(R.id.img_icon);
            tvName = itemView.findViewById(R.id.tv_name);
            tvPoints = itemView.findViewById(R.id.tv_points);
            tvRegulation = itemView.findViewById(R.id.tv_regulation);
            btnState = itemView.findViewById(R.id.btn_state);
        }
    }

    public interface OnItemClickListener {
        void openSignRuler(String code);

        void onClick(PointBean.RvPointItem item);
    }


}
