package com.rv.member.adapter;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.util.glide.GlideManager;

import com.rv.member.R;
import com.rv.member.bean.MemberListBean;
import com.rv.member.view.MemberCardView;
import com.rv.tourism.api.TourismApi;

import java.util.List;

public class MemberListAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private Context mContext;
    private List<MemberListBean.MemberCard> mData;
    private PayListener payListener;
    private int memberLevel;
    private int freeUseDay;
    private GridMemerAdapter adapter;
    private MemberListBean.MemberCard selectCard;
    private int selectPostion;

    public interface PayListener {
        void pay(MemberListBean.MemberCard card);
    }

    public void setMemberLevel(int memberLevel, int freeUseDay) {
        this.memberLevel = memberLevel;
        this.freeUseDay = freeUseDay;
        notifyDataSetChanged();
    }

    public void setDate(List<MemberListBean.MemberCard> data) {
        initData(data);
        notifyDataSetChanged();
    }

    public MemberListAdapter(@Nullable List<MemberListBean.MemberCard> data, int memberLevel, int freeUseDay, Context context, PayListener listener) {
        this.memberLevel = memberLevel;
        this.freeUseDay = freeUseDay;
        this.mContext = context;
        this.payListener = listener;
        selectPostion = 1;
        initData(data);
    }

    private void initData(List<MemberListBean.MemberCard> data) {
        data.add(0, null);
        mData = data;
        selectCard = mData.get(selectPostion);
    }


    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {

        if (i == 0) {
            return new HeadViewHolder(LayoutInflater.from(mContext).inflate(R.layout.view_member_privilege, viewGroup, false));
        }
        return new CommonViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_member_detail, viewGroup, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {

        MemberListBean.MemberCard bean = mData.get(i);
        if (bean == null) {
            setHeadViewData((HeadViewHolder) viewHolder);
        } else {
            setCommonViewData((CommonViewHolder) viewHolder, bean);
        }
    }

    @Override
    public int getItemCount() {
        return mData.size();
    }

    @Override
    public int getItemViewType(int position) {
        if (mData.get(position) == null) {
            return 0;
        }
        return 1;
    }


    /*******
     * 是否已经同意协议
     */
    private boolean hasAgree = false;

    private void setHeadViewData(final HeadViewHolder viewHolder) {
        setMemeberTop(viewHolder);
        SpannableString spannableString = new SpannableString(viewHolder.tv_agreement.getText());
        spannableString.setSpan(new ForegroundColorSpan(Color.parseColor("#FFB74B")), 6, spannableString.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        viewHolder.tv_agreement.setText(spannableString);
        viewHolder.tv_agreement.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                        .withString("title", "合同协议")
                        .withString("url", TourismApi.HTTP_URL_CAR_TYPE_NOTICE)
                        .withInt("type", 18)
                        .navigation();
            }
        });

        viewHolder.img_agree.setImageResource(hasAgree ? R.drawable.common_icon_selected : R.drawable.common_icon_radio_unche);
        viewHolder.btn_buy.setBackgroundResource(hasAgree ? R.drawable.shape_rv_bg_dark_yellow : R.drawable.shape_rv_bg_btn_grap_yellow);
        viewHolder.img_agree.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (hasAgree) {
                    hasAgree = false;
                    viewHolder.img_agree.setImageResource(R.drawable.common_icon_radio_unche);
                    viewHolder.btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_btn_grap_yellow);
                } else {
                    hasAgree = true;
                    viewHolder.img_agree.setImageResource(R.drawable.common_icon_selected);
                    viewHolder.btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_dark_yellow);
                }
            }
        });

        viewHolder.btn_buy.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (!hasAgree) {
                    Toast.makeText(mContext, "需同意服务协议", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (payListener != null) {
                    payListener.pay(selectCard);
                }
            }
        });
        initGridView(viewHolder);
        viewHolder.btn_buy.setText("立即开通" + selectCard.getName());
        viewHolder.btnDisountUse.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                toMainActivity();
            }
        });

        viewHolder.btnFreedayUse.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                toMainActivity();
            }
        });
    }

    private void toMainActivity() {
        ComponentName componentName = new ComponentName(mContext, "com.xxfc.rv.MainActivity");
        Intent intent = new Intent();
        intent.putExtra("to", "home");
        intent.setComponent(componentName);
        mContext.startActivity(intent);
    }

    private void initGridView(final HeadViewHolder viewHolder) {

        viewHolder.gridview.setNumColumns(mData.size() - 1);

        if (adapter == null) {
            adapter = new GridMemerAdapter(mContext, mData.subList(1, mData.size()), new GridMemerAdapter.SelectListener() {
                @Override
                public void select(MemberListBean.MemberCard memberCard) {
                    selectCard = memberCard;
                    selectPostion = mData.indexOf(memberCard);
                    viewHolder.btn_buy.setText("立即开通" + memberCard.getName());
                }
            });
        }
        viewHolder.gridview.setAdapter(adapter);
    }

    private void setMemeberTop(final HeadViewHolder viewHolder) {
        if (memberLevel > 0) {
            viewHolder.rlTop.setVisibility(View.VISIBLE);
            viewHolder.imgFreedayTop.setText(freeUseDay + "天");
            viewHolder.tvFreedayTop.setText("免费用车" + freeUseDay + "天");

            switch (memberLevel) {
                case 1:
                    viewHolder.imgDiscountTop.setImageResource(R.drawable.member_discount_8);
                    viewHolder.tvDiscountTop.setText("租车8折");
                    break;
                case 2:
                    viewHolder.imgDiscountTop.setImageResource(R.drawable.member_discount_7);
                    viewHolder.tvDiscountTop.setText("租车7折");
                    break;
                case 3:
                    viewHolder.imgDiscountTop.setImageResource(R.drawable.member_discount_6);
                    viewHolder.tvDiscountTop.setText("租车6折");
                    break;
            }
        } else {
            viewHolder.rlTop.setVisibility(View.GONE);
        }
    }

    protected void setCommonViewData(CommonViewHolder viewHolder, final MemberListBean.MemberCard bean) {
        if (!TextUtils.isEmpty(bean.getName())) {
            viewHolder.tv_member_type.setText(bean.getName());
            viewHolder.btn_buy.setText("立即开通" + bean.getName());
        }

        viewHolder.btn_buy.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (!hasAgree) {
                    Toast.makeText(mContext, "需同意服务协议", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (payListener != null) {

                    payListener.pay(bean);
                }
            }
        });
        if (!TextUtils.isEmpty(bean.getIcon()))
            GlideManager.getInstance(mContext).loadImage(bean.getIcon(), viewHolder.img_icon);

        SpannableString spannableString = new SpannableString(bean.getName() + bean.getPrice() + "元 (永久)");
        spannableString.setSpan(new ForegroundColorSpan(Color.parseColor("#F25B5B")), bean.getName().length(), spannableString.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        viewHolder.tv_member_type_price_time.setText(spannableString);

        if (!TextUtils.isEmpty(bean.getDescribe())) {
            viewHolder.tv_describe.setText(bean.getDescribe());
        }
        viewHolder.mcv_discount.setValue(bean.getDiscount());
        viewHolder.mcv_free_day.setValue(bean.getNumber());
    }

    public class HeadViewHolder extends RecyclerView.ViewHolder {

        GridView gridview;
        TextView tv_agreement;
        ImageView img_agree;
        Button btn_buy;
        RelativeLayout rlTop;
        ImageView imgDiscountTop;
        TextView tvDiscountTop;
        Button btnDisountUse;
        TextView imgFreedayTop;
        TextView tvFreedayTop;
        Button btnFreedayUse;

        public HeadViewHolder(@NonNull View itemView) {
            super(itemView);
            gridview = itemView.findViewById(R.id.gridview);
            tv_agreement = itemView.findViewById(R.id.tv_agreement);
            img_agree = itemView.findViewById(R.id.img_agree);
            btn_buy = itemView.findViewById(R.id.btn_buy);
            rlTop = itemView.findViewById(R.id.rl_member_top);
            imgDiscountTop = itemView.findViewById(R.id.img_discount_top);
            tvDiscountTop = itemView.findViewById(R.id.tv_discount_top);
            btnDisountUse = itemView.findViewById(R.id.btn_disount_use);
            imgFreedayTop = itemView.findViewById(R.id.img_freeday_top);
            tvFreedayTop = itemView.findViewById(R.id.tv_freeday_top);
            btnFreedayUse = itemView.findViewById(R.id.btn_freeday_use);
        }
    }

    public class CommonViewHolder extends RecyclerView.ViewHolder {
        TextView tv_member_type;
        MemberCardView mcv_discount, mcv_free_day, mcv_free_outdoors;
        ImageView img_icon;
        TextView tv_member_type_price_time;
        TextView tv_describe;
        Button btn_buy;

        public CommonViewHolder(@NonNull View itemView) {
            super(itemView);
            tv_member_type = itemView.findViewById(R.id.tv_member_type);
            mcv_discount = itemView.findViewById(R.id.mcv_discount);
            mcv_free_day = itemView.findViewById(R.id.mcv_free_day);
            mcv_free_outdoors = itemView.findViewById(R.id.mcv_free_outdoors);
            img_icon = itemView.findViewById(R.id.img_icon);
            tv_member_type_price_time = itemView.findViewById(R.id.tv_member_type_price_time);
            tv_describe = itemView.findViewById(R.id.tv_describe);
            btn_buy = itemView.findViewById(R.id.btn_buy);
        }
    }
}
