package com.rv.member.adapter;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.rv.member.R;
import com.rv.member.bean.MemberListBean;

import java.util.List;

public class GridMemerAdapter extends BaseAdapter {

    private int selecPosition;
    private Context mContext;
    private List<MemberListBean.MemberCard> mData;
    private SelectListener mListener;

    public interface SelectListener {
        void select(MemberListBean.MemberCard memberCard);
    }

    public GridMemerAdapter(Context context, List<MemberListBean.MemberCard> lists, SelectListener listener) {
        this.mContext = context;
        this.mData = lists;
        this.mListener = listener;
    }

    @Override
    public int getCount() {
        return mData.size();
    }

    @Override
    public Object getItem(int i) {
        return mData.get(i);
    }

    @Override
    public long getItemId(int i) {
        return i;
    }

    @Override
    public View getView(final int i, View view, ViewGroup viewGroup) {
        final MemberListBean.MemberCard memberCard = mData.get(i);
        ViewHolder holder;
        if (view == null) {
            view = LayoutInflater.from(mContext).inflate(R.layout.item_member_detail_view, null);
            holder = new ViewHolder();
            holder.rl_content = view.findViewById(R.id.rl_content);
            holder.tv_discount = view.findViewById(R.id.tv_discount);
            holder.tv_free_day = view.findViewById(R.id.tv_free_day);
            holder.tv_price = view.findViewById(R.id.tv_price);
            holder.tv_type_icon = view.findViewById(R.id.tv_type_icon);
            view.setTag(holder);
        } else {
            holder = (ViewHolder) view.getTag();
        }

        SpannableString s = new SpannableString("¥" + memberCard.getPrice());

        s.setSpan(new AbsoluteSizeSpan(12, true), 0, 1, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        s.setSpan(new AbsoluteSizeSpan(18, true), 1, s.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        s.setSpan(new ForegroundColorSpan(Color.parseColor("#FFB74B")), 1, s.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        holder.tv_price.setText(s);

        holder.tv_discount.setText("永久" + memberCard.getDiscount() / 10 + "折租车");
        holder.tv_free_day.setText(memberCard.getNumber() + "天免费租车");

        holder.tv_type_icon.setText(memberCard.getName());
        switch (memberCard.getLevel()) {
            case 1:
                holder.tv_type_icon.setBackgroundResource(R.drawable.member_icon_reg_members);
                break;
            case 2:
                holder.tv_type_icon.setBackgroundResource(R.drawable.member_icon_gold_membership);
                break;
            case 3:
                holder.tv_type_icon.setBackgroundResource(R.drawable.member_icon_dia_membership);
                break;
        }
        if (selecPosition == i) {
            holder.rl_content.setBackgroundResource(R.drawable.shape_rv_bg_member_selected);
        } else {
            holder.rl_content.setBackgroundResource(R.drawable.shape_rv_bg_member_unselected);
        }

        holder.rl_content.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                selecPosition = i;
                mListener.select(memberCard);
                notifyDataSetChanged();
            }
        });
        return view;
    }

    private class ViewHolder {
        RelativeLayout rl_content;
        TextView tv_price;
        TextView tv_discount;
        TextView tv_free_day;
        TextView tv_type_icon;
    }
}
