package com.rv.member;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.view.ViewPager;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.util.ScaleUtils;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.horizontal.GallerySnapHelper;
import com.ruiwenliu.wrapper.weight.horizontal.SpaceItemDecoration;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.ruiwenliu.wrapper.adapter.TabAdapter;
import com.rv.home.rv.module.ui.main.home.adapter.OrderMenuAdapter;
import com.ruiwenliu.wrapper.bean.UserInfoBean;
import com.rv.member.fragment.AllDayDetailFragment;
import com.rv.member.fragment.GiveDetailFragment;
import com.rv.member.fragment.UserDetailFragment;
import com.rv.member.view.FreeDayProgressView;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

public class FreesDayActivity extends BaseStatusActivity<CommonPresenter> {

    @BindView(R2.id.progress_view)
    FreeDayProgressView progressView;
    @BindView(R2.id.tv_has_use_day)
    TextView tvHasUseDay;
    @BindView(R2.id.recyclerview)
    RecyclerView recyclerView;
    @BindView(R2.id.viewpager)
    ViewPager viewpager;

    private OrderMenuAdapter menuAdapter;
    private TabAdapter mAdapter;
    private int menuPosition;

    public static Intent getIntent(Context context, UserInfoBean infoBean) {
        Intent intent = new Intent(context, FreesDayActivity.class);
        intent.putExtra("userinfo", infoBean);
        return intent;
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_frees_day;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        menuPosition = 0;
        titleView.setTitle("租车免费天数");
//        handler.sendMessageDelayed(new Message(), 3000);
        initRecyclerView();
        initViewpager();
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    /**
     * 初始化RecyclerView
     */
    private void initRecyclerView() {
        recyclerView.setLayoutManager(new GridLayoutManager(mActivity, 3));
        menuAdapter = new OrderMenuAdapter();
        recyclerView.setAdapter(menuAdapter);
        recyclerView.addItemDecoration(new SpaceItemDecoration(3));
        GallerySnapHelper snapHelper = new GallerySnapHelper();
        snapHelper.attachToRecyclerView(recyclerView);
        List<String> list = new ArrayList<>();
        String[] city = getResources().getStringArray(R.array.free_day_list);
        for (String a : city) {
            list.add(a);
        }
        menuAdapter.setNewData(list);
        menuAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                menuAdapter.setSelectItem(position);
                viewpager.setCurrentItem(position);
            }
        });
    }

    /**
     * 初始化Viewpager
     */
    private void initViewpager() {
        mAdapter = new TabAdapter(getSupportFragmentManager(), getListFragment());
        viewpager.setAdapter(mAdapter);
        viewpager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                menuAdapter.setSelectItem(position);
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        viewpager.setOffscreenPageLimit(mAdapter.getCount());
        menuAdapter.setSelectItem(menuPosition);
        viewpager.setCurrentItem(menuPosition);
    }


    private List<BaseFragment> getListFragment() {
        List<BaseFragment> list = new ArrayList<>();
        list.add(UserDetailFragment.getInstance());
        list.add(GiveDetailFragment.getInstance());
        list.add(AllDayDetailFragment.getInstance());
        return list;
    }


    Handler handler = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            progressView.setData(28, 9, listener);
        }
    };

    private FreeDayProgressView.DrawListener listener = new FreeDayProgressView.DrawListener() {
        @Override
        public void drawFinish(int progressWidth) {
            Toast.makeText(FreesDayActivity.this, "绘制完成", Toast.LENGTH_SHORT).show();
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(tvHasUseDay.getLayoutParams());
            lp.setMargins(progressWidth + ScaleUtils.dip2px(getApplicationContext(), 5), 0, 0, 0);
            tvHasUseDay.setLayoutParams(lp);
            tvHasUseDay.setVisibility(View.VISIBLE);
            tvHasUseDay.setText("已消耗" + 9 + "天");
        }
    };
}
