package com.rv.im.xmpp;

import android.text.TextUtils;

import com.rv.im.log.LogUtil;

import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;

/**
 * 消息发送出去后，判断服务端是否收到，服务端收到后将消息置为送达
 */
public class XServerReceivedListener implements StanzaListener {

//    private String mLoginUserId = ;

    @Override
    public void processStanza(Stanza packet) {
        // Message
        if (packet instanceof Message) {
            Message message = (Message) packet;
            if (message.getType() == Message.Type.chat) {
                LogUtil.e("msg", "单聊：" + message.getPacketID());
                LogUtil.e("msg", "单聊：" + message.getBody());
            } else if (message.getType() == Message.Type.groupchat) {
                LogUtil.e("msg", "群聊：" + message.getPacketID());
                LogUtil.e("msg", "群聊：" + message.getBody());
            } else if (message.getType() == Message.Type.error) {
                LogUtil.e("msg", "error：" + message.getPacketID());
                LogUtil.e("msg", "error：" + message.getBody());
            } else {
                LogUtil.e("msg", "else：" + message.getPacketID());
                LogUtil.e("msg", "else：" + message.getBody());
            }
        }

        LogUtil.e("msg", "packet.getStanzaId()：" + packet.getStanzaId());
        if (TextUtils.isEmpty(packet.getStanzaId())) {
            LogUtil.e("msg", "packet.getStanzaId() == Null Return");
            return;
        }

//        ReceiptManager.ReceiptObj mReceiptObj = ReceiptManager.mReceiptMap.get(packet.getStanzaId());
//        if (mReceiptObj != null) {
//            LogUtil.e("msg", "消息已送至服务器");
//            if (mReceiptObj.Read == 1) {// 已读消息 Type==26
//                if (mLoginUserId.equals(mReceiptObj.toUserId)) {
//                    for (String s : MyApplication.machine) {
//                        ChatMessageDao.getInstance().updateMessageRead(mLoginUserId, s, mReceiptObj.Read_msg_pid, true);
//                    }
//                } else {
//                    ChatMessageDao.getInstance().updateMessageRead(mLoginUserId, mReceiptObj.toUserId, mReceiptObj.Read_msg_pid, true);
//                }
//            } else {// 普通消息 && 新朋友消息
//                if (mReceiptObj.sendType == ReceiptManager.SendType.NORMAL) {
//                    ListenerManager.getInstance().notifyMessageSendStateChange(mLoginUserId, mReceiptObj.toUserId, packet.getStanzaId(),
//                            ChatMessageListener.MESSAGE_SEND_SUCCESS);
//
//                    EventBus.getDefault().post(new MessageEvent(mReceiptObj.toUserId));
//                } else {
//                    ListenerManager.getInstance().notifyNewFriendSendStateChange(mReceiptObj.toUserId, ((NewFriendMessage) mReceiptObj.msg),
//                            ChatMessageListener.MESSAGE_SEND_SUCCESS);
//                }
//            }
//            ReceiptManager.mReceiptMap.remove(packet.getStanzaId());
//        }
    }
}
