package com.rv.im.db.table;

import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.rv.im.enums.CallTypeEnum;
import com.rv.im.enums.MessageStatusEnum;
import com.rv.im.enums.MessageTypeEnum;

import java.io.Serializable;

@DatabaseTable(tableName = "tb_message")
public class ChatMessage implements Serializable {

    @Expose(serialize = false)
    @DatabaseField(columnName = "_id", dataType = DataType.INTEGER, generatedId = true)
    private int id;

    @Expose(serialize = true)
    @DatabaseField(canBeNull = false)
    private String packId; // 消息包的Id

    @Expose(serialize = true)
    @DatabaseField
    private String fromId;

    @Expose(serialize = true)
    @DatabaseField
    private String fromUserId;

    @Expose(serialize = true)
    @DatabaseField
    private String toUserId;

    @Expose(serialize = true)
    @DatabaseField
    private String fromUserName;

    @Expose(serialize = true)
    @DatabaseField
    private String toUserName;

    @Expose(serialize = true)
    @DatabaseField(canBeNull = false)
    @SerializedName("type")
    private int messageType;

    @Expose(serialize = true)
    @DatabaseField
    private int callType; //  当messageType 为5或者6时起效  100：

    @Expose(serialize = true)
    @DatabaseField(canBeNull = false)
    private long timeSend; // 发送时间

    @Expose(serialize = false)
    @DatabaseField
    private int timeReceive; // 接收到消息回执的时间

    @Expose(serialize = false)
    @DatabaseField
    private int timeEnd;   // 结束时间（当为 语音通话/视频通话时）

    @Expose(serialize = false)
    @DatabaseField
    private int upLoadStatus; // 上传状态 1 上传中，2 上传成功，3 上传失败，当类型为  2，3，4时

    @Expose(serialize = false)
    @DatabaseField
    private int uploadSchedule; // 上传进度，当类型为  2，3，4时

    @Expose(serialize = false)
    @DatabaseField
    private boolean isDownload;      //代表是否下载完成

    @Expose(serialize = false)
    @DatabaseField
    private String filePath; // 文件路径

    @Expose(serialize = false)
    @DatabaseField
    private int sipStatus; //    语音或者视频通话的状态，本地数据库存储即可

    @Expose(serialize = false)
    @DatabaseField
    private int messageStatus;  // 消息的发送状态,默认值=0，代表发送中，1 发送成功，2 发送失败

    @Expose(serialize = true)
    @DatabaseField
    private String content; // 内容

    @Expose(serialize = true)
    @DatabaseField
    private int timeLen; // 语音时长

    @Expose(serialize = false)
    @DatabaseField
    private boolean isRead = false; // 是否已读

    @Expose(serialize = false)
    @DatabaseField
    private int isEncrypt = 0;

    @DatabaseField
    private int voiceStatus = 0; // 语音是否已读


    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getFromUserId() {
        return fromUserId;
    }

    public void setFromUserId(String fromUserId) {
        this.fromUserId = fromUserId;
    }

    public String getToUserId() {
        return toUserId;
    }

    public void setToUserId(String toUserId) {
        this.toUserId = toUserId;
    }

    public String getFromUserName() {
        return fromUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public String getToUserName() {
        return toUserName;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public int getMessageType() {
        return messageType;
    }

    public void setMessageType(MessageTypeEnum type) {
        this.messageType = type.getType();
    }

    public long getTimeSend() {
        return timeSend;
    }

    public void setTimeSend(long timeSend) {
        this.timeSend = timeSend;
    }

    public int getTimeReceive() {
        return timeReceive;
    }

    public void setTimeReceive(int timeReceive) {
        this.timeReceive = timeReceive;
    }

    public int getTimeEnd() {
        return timeEnd;
    }

    public void setTimeEnd(int timeEnd) {
        this.timeEnd = timeEnd;
    }

    public boolean isDownload() {
        return isDownload;
    }

    public void setDownload(boolean download) {
        isDownload = download;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public int getUpLoadStatus() {
        return upLoadStatus;
    }

    public void setUpLoadStatus(int upLoadStatus) {
        this.upLoadStatus = upLoadStatus;
    }

    public int getUploadSchedule() {
        return uploadSchedule;
    }

    public void setUploadSchedule(int uploadSchedule) {
        this.uploadSchedule = uploadSchedule;
    }

    public boolean getIsDownload() {
        return isDownload;
    }

    public void setIsDownload(boolean isDownload) {
        this.isDownload = isDownload;
    }

    public int getSipStatus() {
        return sipStatus;
    }

    public void setSipStatus(int sipStatus) {
        this.sipStatus = sipStatus;
    }

    public int getMessageStatus() {
        return messageStatus;
    }

    public int getCallType() {
        return callType;
    }

    public void setCallType(int callType) {
        this.callType = callType;
    }

    public void setCallType(CallTypeEnum callTypeEnum) {
        this.callType = callTypeEnum.getType();
    }

    public void setMessageStatus(MessageStatusEnum statusEnum) {
        this.messageStatus = statusEnum.getStatus();
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getPackId() {
        return packId;
    }

    public void setPackId(String packId) {
        this.packId = packId;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFromId() {
        return fromId;
    }

    public void setFromId(String fromId) {
        this.fromId = fromId;
    }

    public int getTimeLen() {
        return timeLen;
    }

    public void setTimeLen(int timeLen) {
        this.timeLen = timeLen;
    }

    public boolean isRead() {
        return isRead;
    }

    public void setRead(boolean read) {
        isRead = read;
    }

    public int getIsEncrypt() {
        return isEncrypt;
    }

    public void setIsEncrypt(int isEncrypt) {
        this.isEncrypt = isEncrypt;
    }

    public int getVoiceStatus() {
        return voiceStatus;
    }

    public void setVoiceStatus(int voiceStatus) {
        this.voiceStatus = voiceStatus;
    }

    public static ChatMessage json2Message(String json) {
        return new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().fromJson(json, ChatMessage.class);
    }

//    @Override
//    public String toString() {
//        return new Gson().toJson(this);
//    }

    public String toJsonString() {
        return new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().toJson(this);
    }

}
