package com.rv.im.call;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.Log;

import com.rv.im.R;
import com.rv.im.log.LogUtil;

import java.util.HashMap;
import java.util.Map;

public class QuickMeetingActivity extends AppCompatActivity {

    private boolean isNeedExecuteLogin = false;
    private String room;
    private boolean isVideo;

    public QuickMeetingActivity() {

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_quick_meeting);

        if (getSupportActionBar() != null) {
            getSupportActionBar().hide();
        }

//        // 判断本地登录状态
//        int userStatus = LoginHelper.prepareUser(mContext, coreManager);
//        switch (userStatus) {
//            case LoginHelper.STATUS_USER_FULL:
//            case LoginHelper.STATUS_USER_NO_UPDATE:
//            case LoginHelper.STATUS_USER_TOKEN_OVERDUE:
//                boolean isConflict = PreferenceUtils.getBoolean(this, Constants.LOGIN_CONFLICT, false);
//                if (isConflict) {
//                    isNeedExecuteLogin = true;
//                }
//                break;
//            case LoginHelper.STATUS_USER_SIMPLE_TELPHONE:
//                isNeedExecuteLogin = true;
//                break;
//            case LoginHelper.STATUS_NO_USER:
//            default:
//                isNeedExecuteLogin = true;
//        }
//
//        if (isNeedExecuteLogin) {// 需要先执行登录操作
//            login();
//            return;
//        }

        parseParam();
        dial();
    }

    private void parseParam() {
        Intent intent = getIntent();
        Uri data = intent.getData();
        if (data == null) {
            LogUtil.e("data异常");
            login();
            return;
        }
        Map<String, String> map = URLRequest(data.toString());
        room = map.get("room");
        if (TextUtils.isEmpty(room)) {
            login();
            return;
        }
        isVideo = TextUtils.equals(map.get("type"), "video");
    }

    private void dial() {
        Jitsi_connecting_second.start(this, room, isVideo);
        finish();
    }

    private void login() {
//        startActivity(new Intent(mContext, SplashActivity.class));
//        finish();
    }

    /**
     * 解析出url参数中的键值对
     * 如 "index.jsp?Action=del&id=123"，解析出Action:del,id:123存入map中
     *
     * @param URL url地址
     * @return url请求参数部分
     */
    public Map<String, String> URLRequest(String URL) {
        Map<String, String> mapRequest = new HashMap<String, String>();

        String[] arrSplit = null;

        String strUrlParam = TruncateUrlPage(URL);
        if (strUrlParam == null) {
            return mapRequest;
        }
        //每个键值为一组 www.2cto.com
        arrSplit = strUrlParam.split("[&]");
        for (String strSplit : arrSplit) {
            String[] arrSplitEqual = null;
            arrSplitEqual = strSplit.split("[=]");

            //解析出键值
            if (arrSplitEqual.length > 1) {
                //正确解析
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);

            } else {
                if (arrSplitEqual[0] != "") {
                    //只有参数没有值，不加入
                    mapRequest.put(arrSplitEqual[0], "");
                }
            }
        }
        Log.d("mapRequestwebweb", "URLRequest: " + mapRequest.get("webAppName"));
        return mapRequest;
    }

    /**
     * 去掉url中的路径，留下请求参数部分
     *
     * @param strURL url地址
     * @return url请求参数部分
     */
    private String TruncateUrlPage(String strURL) {
        String strAllParam = null;
        String[] arrSplit = null;

        strURL = strURL.trim();

        arrSplit = strURL.split("[?]");
        if (strURL.length() > 1) {
            if (arrSplit.length > 1) {
                if (arrSplit[1] != null) {
                    strAllParam = arrSplit[1];
                }
            }
        }

        return strAllParam;
    }
}
