package com.rv.im.adapter;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.im.R;
import com.rv.im.db.table.Customer;
import com.rv.im.util.SmileyParser;

import java.util.List;

public class CustomerListAdapter extends BaseQuickAdapter<Customer, BaseViewHolder> {

    private SmileyParser parser;

    public CustomerListAdapter(Context context, @Nullable List<Customer> data) {
        super(R.layout.item_customer, data);
        this.parser = SmileyParser.getInstance(context);
    }

    @Override
    protected void convert(BaseViewHolder helper, Customer item) {
        if (!TextUtils.isEmpty(item.getName()))
            helper.setText(R.id.tv_name, item.getName());
        helper.setText(R.id.tv_state, "在线");
        if (!TextUtils.isEmpty(item.getLastMsg()))
//            helper.setText(R.id.tv_last_msg, item.getLastMsg());
            helper.setText(R.id.tv_last_msg, parser.addSmileySpans(deleteHtml(item.getLastMsg()), true));
    }

    private static String deleteHtml(String msg) {
        if (msg == null) {
            return "";
        }
        msg = msg.replaceAll("\n", "\r\n");
        return msg;
    }
}
