package com.rv.im;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;

import com.rv.im.db.SQLiteHelper;
import com.rv.im.db.service.ChatConversationServiceImp;
import com.rv.im.db.service.ChatMessageServiceImp;
import com.rv.im.db.service.CustomerServiceImp;

public class ImSetting {

    private static final String IM_COOKIE = "im_cookie";

    private static SharedPreferences sharedPreferences = null;

    private static Context mContext = null;

    public static Context getContext() {
        return mContext;
    }

    public static void init(Application application) {
        mContext = application;
    }

    public static void setImConfig(String var1, String var2, String var3, String var4) {
        if (mContext == null) {
            throw new NullPointerException("mContext is null");
        } else {
            saveUserId(mContext, var1);
            saveUserName(mContext, var2);
            saveUserPassword(mContext, var3);
            saveImToken(mContext, var4);
        }
    }

    /*******
     * 退出登录
     *
     * 关掉im的xmpp 链接
     * 关闭数据库
     *
     */
    public static void logout() {
//        ChatConversationServiceImp.getInstance(getContext()).release();
        CustomerServiceImp.getInstance(getContext()).release();
        ChatMessageServiceImp.getInstance(getContext()).release();
        SQLiteHelper.closeDb();  // 关掉数据库连接
    }

    private static SharedPreferences getSharePreference(Context context) {
        if (sharedPreferences == null) {
            sharedPreferences = context.getSharedPreferences(IM_COOKIE, Context.MODE_PRIVATE);
        }
        return sharedPreferences;
    }

    private static void saveUserId(Context context, String userId) {
        getSharePreference(context).edit().putString(Constants.KEYS.KEY_IM_USER_ID, userId).commit();
    }

    private static void saveUserName(Context context, String userName) {
        getSharePreference(context).edit().putString(Constants.KEYS.KEY_USER_NAME, userName).commit();
    }

    private static void saveUserPassword(Context context, String userPassword) {
        getSharePreference(context).edit().putString(Constants.KEYS.KEY_USER_PASSWORD, userPassword).commit();
    }

    private static void saveImToken(Context context, String imToken) {
        getSharePreference(context).edit().putString(Constants.KEYS.KEY_USER_IMTOKEN, imToken).commit();
    }

    public static String getUserId() {
        if (mContext == null) return null;
        return getSharePreference(mContext).getString(Constants.KEYS.KEY_IM_USER_ID, "");
    }

    public static String getUserName() {
        if (mContext == null) return null;
        return getSharePreference(mContext).getString(Constants.KEYS.KEY_USER_NAME, "");
    }

    public static String getUserPassword() {
        if (mContext == null) return null;
        return getSharePreference(mContext).getString(Constants.KEYS.KEY_USER_PASSWORD, "");
    }

    public static String getImToken() {
        if (mContext == null) return null;
        return getSharePreference(mContext).getString(Constants.KEYS.KEY_USER_IMTOKEN, "");
    }

}
