package com.xxrv.coupon.adapter;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.ruiwenliu.wrapper.bean.MultiItemBean;
import com.rv.component.utils.DateUtils;
import com.xxrv.coupon.R;
import com.xxrv.coupon.bean.CarCouponBean;
import com.xxrv.coupon.bean.CouponBean;

import java.util.List;

/**
 *  优惠券  租车确认订单
 */

public class CarCouponAdapter extends BaseMultiItemQuickAdapter<MultiItemEntity, BaseViewHolder> {
    public static final int TYPE_CARCOUPON_TITLE = 1;
    public static final int TYPE_CARCOUPON_NAME = 2;

    public CarCouponAdapter(List<MultiItemEntity> data) {
        super(data);
        addItemType(TYPE_CARCOUPON_TITLE, R.layout.rv_item_carcoupon_type_title);
        addItemType(TYPE_CARCOUPON_NAME,R.layout.rv_item_carcoupon);
    }

    @Override
    protected void convert(BaseViewHolder helper, MultiItemEntity bean) {
        switch (helper.getItemViewType()) {
            case TYPE_CARCOUPON_TITLE:
                if (bean !=null){
                    CarCouponBean.DataBean.CarCouponTypeDataBean item = (CarCouponBean.DataBean.CarCouponTypeDataBean) bean;
                    if ("1".equals(item.getType())) { //1满减券 2叠加满减券 3无门槛券（需要限制大小
                        helper.setText(R.id.tv_type_title, "满减券");
                    }else if ("2".equals(item.getType())){
                        helper.setText(R.id.tv_type_title, "叠加满减券");
                    }else if ("3".equals(item.getType())){
                        helper.setText(R.id.tv_type_title, "无门槛券");
                    }
                }
                break;
            case TYPE_CARCOUPON_NAME:
                if (bean !=null){
                    CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean item = (CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean) bean;
                    helper.setText(R.id.tv_name,item.getTitle());
                    helper.setText(R.id.tv_type,item.getSubtitle());
                    helper.setText(R.id.tv_date,"有效期至" + DateUtils.timestampToString2(item.getExpireTime()));
                    helper.setText(R.id.tv_amount,String.valueOf(item.getUsedAmount()));
                    if ("1".equals(item.getType())){  //1满减券 2叠加满减券 3无门槛券
                        helper.setText(R.id.tv_condition,"满"+item.getWithAmount()+"减"+item.getUsedAmount()+"元");
                    }else if ("3".equals(item.getType())){
                        helper.setText(R.id.tv_condition,"无门槛");
                    }

                    if (item.isCheck()){
                        helper.getView(R.id.iv_select).setSelected(true);
                    }else {
                        helper.getView(R.id.iv_select).setSelected(false);
                    }

                    if ("1".equals(item.getStatus())){
                        helper.setGone(R.id.tv_layout_gray,false);
                    }else {
                        helper.setGone(R.id.tv_layout_gray,true);
                    }
                }
                break;
        }
    }
}
