package com.rv.home.rv.module.ui.main.home.order.view;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.widget.TextView;

import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;

import java.lang.reflect.Field;
import java.util.Timer;
import java.util.TimerTask;

public class MyTimerView extends TextView {

    private long efftiveTime;
    private long crTime;
    private Timer timer;
    private TimerListener mListener;
    private RecyclerView.ViewHolder holder;
    private MyTimerTask task;

    public MyTimerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    /********
     * @param efftiveTime
     *         失效时间
     * @param crTime
     *         创建时间
     * @param listener
     */
    public void setTime(long efftiveTime, long crTime, RecyclerView.ViewHolder holder, TimerListener listener) {
        if (task != null) {
            task.cancel();
        }
        task = new MyTimerTask();
        this.efftiveTime = efftiveTime;
        this.crTime = crTime;
        this.mListener = listener;
        this.holder = holder;
        showEffTime();
        startTimer();
    }

    private void showEffTime() {
        long mTime = efftiveTime - (System.currentTimeMillis() - crTime);
        if (mTime > 0) {
            int day = 0;
            int hour = 0;
            int min = 0;
            int seconds = (int) (mTime / 1000);
            if (seconds > 60) {
                min = seconds / 60;
                seconds = seconds % 60;
                if (min > 60) {
                    hour = min / 60;
                    min = min % 60;
                    if (hour > 24) {
                        day = hour / 24;
                        hour = hour % 24;
                    }
                }
            }
            StringBuilder builder = new StringBuilder();
            builder.append("剩余");
            if (day > 0) {
                builder.append(day + "天");
            }

            dealTime(false, hour, builder);
            dealTime(false, min, builder);
            dealTime(true, seconds, builder);
            setText(builder.toString());
            setVisibility(VISIBLE);
        } else {
            if (mListener != null) {
                mListener.onTimeFinish(this.holder);
            }
            setVisibility(GONE);
            if (timer != null) {
                timer.cancel();
                timer = null;
            }
        }
    }

    private void dealTime(boolean isSecond, int hms, StringBuilder builder) {
        if (hms < 10) {
            builder.append("0");
        }
        builder.append(hms);
        if (!isSecond) {
            builder.append(":");
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (timer != null) {
            timer.cancel();
        }
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
        }
    }

    /*****
     * 开始计时
     */
    public void startTimer() {
        timer = new Timer();
        timer.schedule(task, 0, 1000);
    }

    private class MyTimerTask extends TimerTask {
        @Override
        public void run() {
            handler.sendEmptyMessage(0);
        }
    }

    ;


    private Handler handler = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {
            showEffTime();
        }
    };

    public interface TimerListener {
        void onTimeFinish(RecyclerView.ViewHolder holder);
    }

}
