package com.rv.home.rv.module.ui.main.home.adapter;

import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.ruiwenliu.wrapper.util.TransformationUtil;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.util.glide.GlideOptions;
import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.bean.HomeRecommendBean;

public class RVEnthusiastAdapter extends BaseQuickAdapter<HomeRecommendBean.DataBeanX.DataBean, BaseGlideHolder> {

    public RVEnthusiastAdapter() {
        super(R.layout.rv_item_rv_enthusiast);
    }

    @Override
    protected void convert(BaseGlideHolder helper, HomeRecommendBean.DataBeanX.DataBean item) {
        HomeRecommendBean.DataBeanX.DataBean.Body body = item.getBody();
        if (body != null) {
            if (body.getImages() != null && body.getImages().size() > 0) {

//                GlideManager.getInstance(mContext).loadRoundImage2(body.getImages().get(0).getOurl(), (ImageView) helper.getView(R.id.iv_icon_pat),8);

                ImageView image = helper.getView(R.id.iv_icon_pat);
                GlideOptions options = GlideOptions.placeholderOf(com.ruiwenliu.wrapper.R.drawable.glide_icon_placeholder).
                        error(com.ruiwenliu.wrapper.R.drawable.glide_icon_error);
                TransformationUtil utils = new TransformationUtil(image);
                Glide.with(mContext)
                        .asBitmap()
                        .load(body.getImages().get(0).getOurl())
                        .apply(options)
                        .apply(RequestOptions.bitmapTransform(new RoundedCorners(12)).override(image.getWidth(), image.getHeight()))
                        .into(utils);
            }

            helper.setText(R.id.tv_title, body.getText());
            if ("4".equals(body.getType())) { //消息类型 基础属性 1=文字消息、2=图文消息、3=语音消息、4=视频消息、 5=文件消
                helper.setGone(R.id.iv_isvideo, true);
            } else {
                helper.setGone(R.id.iv_isvideo, false);
            }
        }
        helper.setText(R.id.tv_user_name, item.getNickname());
        GlideManager.getInstance(mContext).loadImage(item.getPicUrl(), (ImageView) helper.getView(R.id.iv_user_icon));
        if (item.getCount() != null) {
            helper.setText(R.id.iv_like_number, item.getCount().getPraise());
        }
        if ("1".equals(item.getIsPraise())) { //0：未点赞 1：已点赞
            helper.setImageResource(R.id.iv_like, R.drawable.icon_discovery_ask_like);
        } else {
            helper.setImageResource(R.id.iv_like, R.drawable.icon_discovery_ask_unlike);
        }

        helper.addOnClickListener(R.id.ll_item_islike);
    }
}
