package com.base.utils.tools.thread;

/**
 * 那么什么是线程池，它有什么优点呢？
 * 1.重用线程池中的线程，避免因为线程的创建和销毁所带来的性能开销。
 * 2.能有效控制线程池的最大并发数，避免大量的线程之间因相互抢占系统资源而导致的堵塞线程。
 * 3.能够对线程进行简单的管理，并提供定时执行以及指定间隔循环执行等功能。
 * 4.相对于AsyncTask来说，最大的优势在于：线程可控！比如在离开了某个页面，提交到AsyncTask不能的任务不能撤销，线程池可以在不需要的时候将某个线程移除
 * <p>
 * 每一个参数的意义:
 * 1.corePoolSize：核心池的大小，在创建了线程池后，默认情况下，线程池中并没有任何线程，而是等待有任务到来才创建线程去执行任务，当线程池中的线程数目达到corePoolSize后，就会把到达的任务放到缓存队列当中。只有当工作队列满了的情况下才会创建超出这个数量的线程。如果某个线程的空闲时间超过了活动时间，那么将标记为可回收，并且只有当线程池的当前大小超过corePoolSize时该线程才会被终止。用户可调用prestartAllCoreThreads()或者prestartCoreThread()方法预先创建线程，即在没有任务到来之前就创建corePoolSize个线程或者一个线程。
 * 2.maximumPoolSize：线程池最大线程数，这个参数也是一个非常重要的参数，它表示在线程池中最多能创建多少个线程；当大于了这个值就会将Thread由一个丢弃处理机制来处理。
 * 3.keepAliveTime：表示线程没有任务执行时最多保持多久时间会终止。默认情况下，只有当线程池中的线程数大于corePoolSize时，keepAliveTime才会起作用，直到线程池中的线程数不大于corePoolSize，即当线程池中的线程数大于corePoolSize时，如果一个线程空闲的时间达到keepAliveTime，则会终止，直到线程池中的线程数不超过corePoolSize。但是如果调用了allowCoreThreadTimeOut(boolean)方法，在线程池中的线程数不大于corePoolSize时，keepAliveTime参数也会起作用，直到线程池中的线程数为0；
 * 4.Unit：参数keepAliveTime的时间单位，有7种取值，在TimeUnit类中有7种静态属性。
 * 5.workQueue：一个阻塞队列，用来存储等待执行的任务，当线程池中的线程数目达到corePoolSize后，就会把到达的任务放到缓存队列当中。
 * 6.threadFactory：线程工厂，主要用来创建线程；
 * 7.handler：表示当拒绝处理任务时的策略，也就是参数maximumPoolSize达到后丢弃处理的方法。有以下四种取值：
 * ThreadPoolExecutor.AbortPolicy:丢弃任务并抛出RejectedExecutionException异常。
 * ThreadPoolExecutor.DiscardPolicy：也是丢弃任务，但是不抛出异常。
 * ThreadPoolExecutor.DiscardOldestPolicy：丢弃队列最前面的任务，然后重新尝试执行任务（重复此过程）
 * ThreadPoolExecutor.CallerRunsPolicy：由调用线程处理该任务
 * 用户也可以实现接口RejectedExecutionHandler定制自己的策略
 *
 * 用法
 * ThreadPoolProxyFactory .getNormalThreadPoolProxy().execute(Runnable);
 * Created by YUYIFE on 2018/8/29.
 */

public class ThreadPoolProxyFactory {
    static ThreadPoolProxy mNormalThreadPoolProxy;
    static ThreadPoolProxy mDownLoadThreadPoolProxy;

    /**
     * 得到普通线程池代理对象mNormalThreadPoolProxy
     */
    public static ThreadPoolProxy getNormalThreadPoolProxy() {
        if (mNormalThreadPoolProxy == null) {
            synchronized (ThreadPoolProxyFactory.class) {
                if (mNormalThreadPoolProxy == null) {
                    mNormalThreadPoolProxy = new ThreadPoolProxy(5, 5);
                }
            }
        }
        return mNormalThreadPoolProxy;
    }

    /**
     * 得到下载线程池代理对象mDownLoadThreadPoolProxy
     */
    public static ThreadPoolProxy getDownLoadThreadPoolProxy() {
        if (mDownLoadThreadPoolProxy == null) {
            synchronized (ThreadPoolProxyFactory.class) {
                if (mDownLoadThreadPoolProxy == null) {
                    mDownLoadThreadPoolProxy = new ThreadPoolProxy(3, 3);
                }
            }
        }
        return mDownLoadThreadPoolProxy;
    }
}



