package com.base.animset.util;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.View;


/**
 * 动画
 */

public class AnimUtil {

    private View view;

    private AnimUtil(View view) {
        this.view = view;
    }

    public static AnimUtil getInstance(View view) {
        return new AnimUtil(view);
    }

    private static AnimatorSet animatorSet;

    /**
     * 单次 放缩
     */
    public void startOfFloatScale() {
        animatorSet = new AnimatorSet();
        ObjectAnimator animX = ObjectAnimator.ofFloat(view, "scaleX", 0.7f, 0.9f, 1.1f, 1.3f, 1.1f, 0.9f, 0.7f);
        ObjectAnimator animY = ObjectAnimator.ofFloat(view, "scaleY", 0.7f, 0.9f, 1.1f, 1.3f, 1.1f, 0.9f, 0.7f);
        animatorSet.setDuration(2600);
        animatorSet.playTogether(animX, animY);
        animatorSet.start();
    }

    private void stopOfFloatScale() {
        if (animatorSet != null) {
            animatorSet.end();//恢复原来的大小
            animatorSet.cancel();
            animatorSet = null;
        }
    }


    private final static int START_ANIM = 1;
    private Handler  mHandler = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case START_ANIM:
                    startOfFloatScale();
                    if (mHandler != null)
                        mHandler.sendEmptyMessageDelayed(START_ANIM, 2600);
                    break;
            }
        }
    };
    /**
     * 启动循环播放
     */
    public void startAnim() {
        stopAnim();
        mHandler.sendEmptyMessage(START_ANIM);
    }

    /**
     * 停止循环播放
     */
    public void stopAnim() {
        stopOfFloatScale();
        if (mHandler!=null) {
            mHandler.removeMessages(START_ANIM);
        }
    }
}
