/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.dao.RawRowMapper;
import com.j256.ormlite.dao.RawRowObjectMapper;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.PreparedStmt;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.RawResultsImpl;
import com.j256.ormlite.stmt.RawRowMapperImpl;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.SelectIterator;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.mapped.MappedCreate;
import com.j256.ormlite.stmt.mapped.MappedDelete;
import com.j256.ormlite.stmt.mapped.MappedDeleteCollection;
import com.j256.ormlite.stmt.mapped.MappedQueryForId;
import com.j256.ormlite.stmt.mapped.MappedRefresh;
import com.j256.ormlite.stmt.mapped.MappedUpdate;
import com.j256.ormlite.stmt.mapped.MappedUpdateId;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementExecutor<T, ID>
implements GenericRowMapper<String[]> {
    private static Logger logger = LoggerFactory.getLogger(StatementExecutor.class);
    private static final FieldType[] noFieldTypes = new FieldType[0];
    private final DatabaseType databaseType;
    private final TableInfo<T, ID> tableInfo;
    private final Dao<T, ID> dao;
    private MappedQueryForId<T, ID> mappedQueryForId;
    private PreparedQuery<T> preparedQueryForAll;
    private MappedCreate<T, ID> mappedInsert;
    private MappedUpdate<T, ID> mappedUpdate;
    private MappedUpdateId<T, ID> mappedUpdateId;
    private MappedDelete<T, ID> mappedDelete;
    private MappedRefresh<T, ID> mappedRefresh;
    private String countStarQuery;
    private String ifExistsQuery;
    private FieldType[] ifExistsFieldTypes;
    private RawRowMapper<T> rawRowMapper;

    public StatementExecutor(DatabaseType databaseType, TableInfo<T, ID> tableInfo, Dao<T, ID> dao) {
        this.databaseType = databaseType;
        this.tableInfo = tableInfo;
        this.dao = dao;
    }

    public T queryForId(DatabaseConnection databaseConnection, ID id, ObjectCache objectCache) throws SQLException {
        if (this.mappedQueryForId == null) {
            this.mappedQueryForId = MappedQueryForId.build(this.databaseType, this.tableInfo, null);
        }
        return this.mappedQueryForId.execute(databaseConnection, id, objectCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T queryForFirst(DatabaseConnection databaseConnection, PreparedStmt<T> preparedStmt, ObjectCache objectCache) throws SQLException {
        CompiledStatement stmt = preparedStmt.compile(databaseConnection, StatementBuilder.StatementType.SELECT);
        DatabaseResults results = null;
        try {
            results = stmt.runQuery(objectCache);
            if (results.first()) {
                logger.debug("query-for-first of '{}' returned at least 1 result", (Object)preparedStmt.getStatement());
                Object t = preparedStmt.mapRow(results);
                return t;
            }
            logger.debug("query-for-first of '{}' returned at 0 results", (Object)preparedStmt.getStatement());
            T t = null;
            return t;
        }
        finally {
            if (results != null) {
                results.close();
            }
            stmt.close();
        }
    }

    public List<T> queryForAll(ConnectionSource connectionSource, ObjectCache objectCache) throws SQLException {
        this.prepareQueryForAll();
        return this.query(connectionSource, this.preparedQueryForAll, objectCache);
    }

    public long queryForCountStar(DatabaseConnection databaseConnection) throws SQLException {
        if (this.countStarQuery == null) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("SELECT COUNT(*) FROM ");
            this.databaseType.appendEscapedEntityName(sb, this.tableInfo.getTableName());
            this.countStarQuery = sb.toString();
        }
        long count = databaseConnection.queryForLong(this.countStarQuery);
        logger.debug("query of '{}' returned {}", (Object)this.countStarQuery, (Object)count);
        return count;
    }

    public long queryForLong(DatabaseConnection databaseConnection, PreparedStmt<T> preparedStmt) throws SQLException {
        CompiledStatement stmt = preparedStmt.compile(databaseConnection, StatementBuilder.StatementType.SELECT_LONG);
        DatabaseResults results = null;
        try {
            results = stmt.runQuery(null);
            if (results.first()) {
                long l = results.getLong(0);
                return l;
            }
            throw new SQLException("No result found in queryForLong: " + preparedStmt.getStatement());
        }
        finally {
            if (results != null) {
                results.close();
            }
            stmt.close();
        }
    }

    public long queryForLong(DatabaseConnection databaseConnection, String query, String[] arguments) throws SQLException {
        logger.debug("executing raw query for long: {}", (Object)query);
        if (arguments.length > 0) {
            logger.trace("query arguments: {}", (Object)arguments);
        }
        CompiledStatement stmt = null;
        DatabaseResults results = null;
        try {
            stmt = databaseConnection.compileStatement(query, StatementBuilder.StatementType.SELECT, noFieldTypes, -1);
            this.assignStatementArguments(stmt, arguments);
            results = stmt.runQuery(null);
            if (results.first()) {
                long l = results.getLong(0);
                return l;
            }
            throw new SQLException("No result found in queryForLong: " + query);
        }
        finally {
            if (results != null) {
                results.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> query(ConnectionSource connectionSource, PreparedStmt<T> preparedStmt, ObjectCache objectCache) throws SQLException {
        SelectIterator<T, ID> iterator = this.buildIterator(null, connectionSource, preparedStmt, objectCache, -1);
        try {
            ArrayList<T> results = new ArrayList<T>();
            while (iterator.hasNextThrow()) {
                results.add(iterator.nextThrow());
            }
            logger.debug("query of '{}' returned {} results", (Object)preparedStmt.getStatement(), (Object)results.size());
            ArrayList<T> arrayList = results;
            return arrayList;
        }
        finally {
            iterator.close();
        }
    }

    public SelectIterator<T, ID> buildIterator(BaseDaoImpl<T, ID> classDao, ConnectionSource connectionSource, int resultFlags, ObjectCache objectCache) throws SQLException {
        this.prepareQueryForAll();
        return this.buildIterator(classDao, connectionSource, this.preparedQueryForAll, objectCache, resultFlags);
    }

    public GenericRowMapper<T> getSelectStarRowMapper() throws SQLException {
        this.prepareQueryForAll();
        return this.preparedQueryForAll;
    }

    public RawRowMapper<T> getRawRowMapper() {
        if (this.rawRowMapper == null) {
            this.rawRowMapper = new RawRowMapperImpl<T, ID>(this.tableInfo);
        }
        return this.rawRowMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectIterator<T, ID> buildIterator(BaseDaoImpl<T, ID> classDao, ConnectionSource connectionSource, PreparedStmt<T> preparedStmt, ObjectCache objectCache, int resultFlags) throws SQLException {
        DatabaseConnection connection = connectionSource.getReadOnlyConnection();
        CompiledStatement compiledStatement = null;
        try {
            compiledStatement = preparedStmt.compile(connection, StatementBuilder.StatementType.SELECT, resultFlags);
            SelectIterator<T, ID> iterator = new SelectIterator<T, ID>(this.tableInfo.getDataClass(), classDao, preparedStmt, connectionSource, connection, compiledStatement, preparedStmt.getStatement(), objectCache);
            connection = null;
            compiledStatement = null;
            SelectIterator<T, ID> selectIterator = iterator;
            return selectIterator;
        }
        finally {
            if (compiledStatement != null) {
                compiledStatement.close();
            }
            if (connection != null) {
                connectionSource.releaseConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericRawResults<String[]> queryRaw(ConnectionSource connectionSource, String query, String[] arguments, ObjectCache objectCache) throws SQLException {
        logger.debug("executing raw query for: {}", (Object)query);
        if (arguments.length > 0) {
            logger.trace("query arguments: {}", (Object)arguments);
        }
        DatabaseConnection connection = connectionSource.getReadOnlyConnection();
        CompiledStatement compiledStatement = null;
        try {
            compiledStatement = connection.compileStatement(query, StatementBuilder.StatementType.SELECT, noFieldTypes, -1);
            this.assignStatementArguments(compiledStatement, arguments);
            RawResultsImpl<String[]> rawResults = new RawResultsImpl<String[]>(connectionSource, connection, query, String[].class, compiledStatement, this, objectCache);
            compiledStatement = null;
            connection = null;
            RawResultsImpl<String[]> rawResultsImpl = rawResults;
            return rawResultsImpl;
        }
        finally {
            if (compiledStatement != null) {
                compiledStatement.close();
            }
            if (connection != null) {
                connectionSource.releaseConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <UO> GenericRawResults<UO> queryRaw(ConnectionSource connectionSource, String query, RawRowMapper<UO> rowMapper, String[] arguments, ObjectCache objectCache) throws SQLException {
        logger.debug("executing raw query for: {}", (Object)query);
        if (arguments.length > 0) {
            logger.trace("query arguments: {}", (Object)arguments);
        }
        DatabaseConnection connection = connectionSource.getReadOnlyConnection();
        CompiledStatement compiledStatement = null;
        try {
            compiledStatement = connection.compileStatement(query, StatementBuilder.StatementType.SELECT, noFieldTypes, -1);
            this.assignStatementArguments(compiledStatement, arguments);
            RawResultsImpl<UO> rawResults = new RawResultsImpl<UO>(connectionSource, connection, query, String[].class, compiledStatement, new UserRawRowMapper<UO>(rowMapper, this), objectCache);
            compiledStatement = null;
            connection = null;
            RawResultsImpl<UO> rawResultsImpl = rawResults;
            return rawResultsImpl;
        }
        finally {
            if (compiledStatement != null) {
                compiledStatement.close();
            }
            if (connection != null) {
                connectionSource.releaseConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <UO> GenericRawResults<UO> queryRaw(ConnectionSource connectionSource, String query, DataType[] columnTypes, RawRowObjectMapper<UO> rowMapper, String[] arguments, ObjectCache objectCache) throws SQLException {
        logger.debug("executing raw query for: {}", (Object)query);
        if (arguments.length > 0) {
            logger.trace("query arguments: {}", (Object)arguments);
        }
        DatabaseConnection connection = connectionSource.getReadOnlyConnection();
        CompiledStatement compiledStatement = null;
        try {
            compiledStatement = connection.compileStatement(query, StatementBuilder.StatementType.SELECT, noFieldTypes, -1);
            this.assignStatementArguments(compiledStatement, arguments);
            RawResultsImpl<UO> rawResults = new RawResultsImpl<UO>(connectionSource, connection, query, String[].class, compiledStatement, new UserRawRowObjectMapper<UO>(rowMapper, columnTypes), objectCache);
            compiledStatement = null;
            connection = null;
            RawResultsImpl<UO> rawResultsImpl = rawResults;
            return rawResultsImpl;
        }
        finally {
            if (compiledStatement != null) {
                compiledStatement.close();
            }
            if (connection != null) {
                connectionSource.releaseConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericRawResults<Object[]> queryRaw(ConnectionSource connectionSource, String query, DataType[] columnTypes, String[] arguments, ObjectCache objectCache) throws SQLException {
        logger.debug("executing raw query for: {}", (Object)query);
        if (arguments.length > 0) {
            logger.trace("query arguments: {}", (Object)arguments);
        }
        DatabaseConnection connection = connectionSource.getReadOnlyConnection();
        CompiledStatement compiledStatement = null;
        try {
            compiledStatement = connection.compileStatement(query, StatementBuilder.StatementType.SELECT, noFieldTypes, -1);
            this.assignStatementArguments(compiledStatement, arguments);
            RawResultsImpl<Object[]> rawResults = new RawResultsImpl<Object[]>(connectionSource, connection, query, Object[].class, compiledStatement, new ObjectArrayRowMapper(columnTypes), objectCache);
            compiledStatement = null;
            connection = null;
            RawResultsImpl<Object[]> rawResultsImpl = rawResults;
            return rawResultsImpl;
        }
        finally {
            if (compiledStatement != null) {
                compiledStatement.close();
            }
            if (connection != null) {
                connectionSource.releaseConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateRaw(DatabaseConnection connection, String statement, String[] arguments) throws SQLException {
        logger.debug("running raw update statement: {}", (Object)statement);
        if (arguments.length > 0) {
            logger.trace("update arguments: {}", (Object)arguments);
        }
        CompiledStatement compiledStatement = connection.compileStatement(statement, StatementBuilder.StatementType.UPDATE, noFieldTypes, -1);
        try {
            this.assignStatementArguments(compiledStatement, arguments);
            int n = compiledStatement.runUpdate();
            return n;
        }
        finally {
            compiledStatement.close();
        }
    }

    public int executeRawNoArgs(DatabaseConnection connection, String statement) throws SQLException {
        logger.debug("running raw execute statement: {}", (Object)statement);
        return connection.executeStatement(statement, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeRaw(DatabaseConnection connection, String statement, String[] arguments) throws SQLException {
        logger.debug("running raw execute statement: {}", (Object)statement);
        if (arguments.length > 0) {
            logger.trace("execute arguments: {}", (Object)arguments);
        }
        CompiledStatement compiledStatement = connection.compileStatement(statement, StatementBuilder.StatementType.EXECUTE, noFieldTypes, -1);
        try {
            this.assignStatementArguments(compiledStatement, arguments);
            int n = compiledStatement.runExecute();
            return n;
        }
        finally {
            compiledStatement.close();
        }
    }

    public int create(DatabaseConnection databaseConnection, T data, ObjectCache objectCache) throws SQLException {
        if (this.mappedInsert == null) {
            this.mappedInsert = MappedCreate.build(this.databaseType, this.tableInfo);
        }
        return this.mappedInsert.insert(this.databaseType, databaseConnection, data, objectCache);
    }

    public int update(DatabaseConnection databaseConnection, T data, ObjectCache objectCache) throws SQLException {
        if (this.mappedUpdate == null) {
            this.mappedUpdate = MappedUpdate.build(this.databaseType, this.tableInfo);
        }
        return this.mappedUpdate.update(databaseConnection, data, objectCache);
    }

    public int updateId(DatabaseConnection databaseConnection, T data, ID newId, ObjectCache objectCache) throws SQLException {
        if (this.mappedUpdateId == null) {
            this.mappedUpdateId = MappedUpdateId.build(this.databaseType, this.tableInfo);
        }
        return this.mappedUpdateId.execute(databaseConnection, data, newId, objectCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(DatabaseConnection databaseConnection, PreparedUpdate<T> preparedUpdate) throws SQLException {
        CompiledStatement stmt = preparedUpdate.compile(databaseConnection, StatementBuilder.StatementType.UPDATE);
        try {
            int n = stmt.runUpdate();
            return n;
        }
        finally {
            stmt.close();
        }
    }

    public int refresh(DatabaseConnection databaseConnection, T data, ObjectCache objectCache) throws SQLException {
        if (this.mappedRefresh == null) {
            this.mappedRefresh = MappedRefresh.build(this.databaseType, this.tableInfo);
        }
        return this.mappedRefresh.executeRefresh(databaseConnection, data, objectCache);
    }

    public int delete(DatabaseConnection databaseConnection, T data, ObjectCache objectCache) throws SQLException {
        if (this.mappedDelete == null) {
            this.mappedDelete = MappedDelete.build(this.databaseType, this.tableInfo);
        }
        return this.mappedDelete.delete(databaseConnection, data, objectCache);
    }

    public int deleteById(DatabaseConnection databaseConnection, ID id, ObjectCache objectCache) throws SQLException {
        if (this.mappedDelete == null) {
            this.mappedDelete = MappedDelete.build(this.databaseType, this.tableInfo);
        }
        return this.mappedDelete.deleteById(databaseConnection, id, objectCache);
    }

    public int deleteObjects(DatabaseConnection databaseConnection, Collection<T> datas, ObjectCache objectCache) throws SQLException {
        return MappedDeleteCollection.deleteObjects(this.databaseType, this.tableInfo, databaseConnection, datas, objectCache);
    }

    public int deleteIds(DatabaseConnection databaseConnection, Collection<ID> ids, ObjectCache objectCache) throws SQLException {
        return MappedDeleteCollection.deleteIds(this.databaseType, this.tableInfo, databaseConnection, ids, objectCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(DatabaseConnection databaseConnection, PreparedDelete<T> preparedDelete) throws SQLException {
        CompiledStatement stmt = preparedDelete.compile(databaseConnection, StatementBuilder.StatementType.DELETE);
        try {
            int n = stmt.runUpdate();
            return n;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * Exception decompiling
     */
    public <CT> CT callBatchTasks(DatabaseConnection connection, boolean saved, Callable<CT> callable) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String[] mapRow(DatabaseResults results) throws SQLException {
        int columnN = results.getColumnCount();
        String[] result = new String[columnN];
        for (int colC = 0; colC < columnN; ++colC) {
            result[colC] = results.getString(colC);
        }
        return result;
    }

    public boolean ifExists(DatabaseConnection connection, ID id) throws SQLException {
        if (this.ifExistsQuery == null) {
            QueryBuilder<T, ID> qb = new QueryBuilder<T, ID>(this.databaseType, this.tableInfo, this.dao);
            qb.selectRaw("COUNT(*)");
            qb.where().eq(this.tableInfo.getIdField().getColumnName(), new SelectArg());
            this.ifExistsQuery = qb.prepareStatementString();
            this.ifExistsFieldTypes = new FieldType[]{this.tableInfo.getIdField()};
        }
        long count = connection.queryForLong(this.ifExistsQuery, new Object[]{id}, this.ifExistsFieldTypes);
        logger.debug("query of '{}' returned {}", (Object)this.ifExistsQuery, (Object)count);
        return count != 0L;
    }

    private void assignStatementArguments(CompiledStatement compiledStatement, String[] arguments) throws SQLException {
        for (int i = 0; i < arguments.length; ++i) {
            compiledStatement.setObject(i, arguments[i], SqlType.STRING);
        }
    }

    private void prepareQueryForAll() throws SQLException {
        if (this.preparedQueryForAll == null) {
            this.preparedQueryForAll = new QueryBuilder<T, ID>(this.databaseType, this.tableInfo, this.dao).prepare();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectArrayRowMapper
    implements GenericRowMapper<Object[]> {
        private final DataType[] columnTypes;

        public ObjectArrayRowMapper(DataType[] columnTypes) {
            this.columnTypes = columnTypes;
        }

        @Override
        public Object[] mapRow(DatabaseResults results) throws SQLException {
            int columnN = results.getColumnCount();
            Object[] result = new Object[columnN];
            for (int colC = 0; colC < columnN; ++colC) {
                DataType dataType = colC >= this.columnTypes.length ? DataType.STRING : this.columnTypes[colC];
                result[colC] = dataType.getDataPersister().resultToJava(null, results, colC);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserRawRowObjectMapper<UO>
    implements GenericRowMapper<UO> {
        private final RawRowObjectMapper<UO> mapper;
        private final DataType[] columnTypes;
        private String[] columnNames;

        public UserRawRowObjectMapper(RawRowObjectMapper<UO> mapper, DataType[] columnTypes) {
            this.mapper = mapper;
            this.columnTypes = columnTypes;
        }

        @Override
        public UO mapRow(DatabaseResults results) throws SQLException {
            int columnN = results.getColumnCount();
            Object[] objectResults = new Object[columnN];
            for (int colC = 0; colC < columnN; ++colC) {
                objectResults[colC] = colC >= this.columnTypes.length ? null : this.columnTypes[colC].getDataPersister().resultToJava(null, results, colC);
            }
            return this.mapper.mapRow(this.getColumnNames(results), this.columnTypes, objectResults);
        }

        private String[] getColumnNames(DatabaseResults results) throws SQLException {
            if (this.columnNames != null) {
                return this.columnNames;
            }
            this.columnNames = results.getColumnNames();
            return this.columnNames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserRawRowMapper<UO>
    implements GenericRowMapper<UO> {
        private final RawRowMapper<UO> mapper;
        private final GenericRowMapper<String[]> stringRowMapper;
        private String[] columnNames;

        public UserRawRowMapper(RawRowMapper<UO> mapper, GenericRowMapper<String[]> stringMapper) {
            this.mapper = mapper;
            this.stringRowMapper = stringMapper;
        }

        @Override
        public UO mapRow(DatabaseResults results) throws SQLException {
            String[] stringResults = this.stringRowMapper.mapRow(results);
            return this.mapper.mapRow(this.getColumnNames(results), stringResults);
        }

        private String[] getColumnNames(DatabaseResults results) throws SQLException {
            if (this.columnNames != null) {
                return this.columnNames;
            }
            this.columnNames = results.getColumnNames();
            return this.columnNames;
        }
    }
}

