package com.xxfc.member.controller;

import com.github.wxiaoqi.security.common.msg.BaseResponse;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.msg.TableResultResponse;
import com.xxfc.member.MemberApplicationTests;
import com.xxfc.member.entity.MemberFamilyInfo;
import com.xxfc.member.vo.MemberFamilyInfoVo;
import com.xxfc.member.vo.MemberInfoVo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.springframework.beans.factory.annotation.Autowired;

import javax.persistence.Table;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static com.xxfc.member.entity.MemberInfo.SEX_MAN;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class MemberInfoControllerTest extends MemberApplicationTests {

    private MemberInfoVo memberInfoVo;

    @Autowired
    private MemberInfoController controller;

    @Before
    public void setUp() throws Exception {

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");

        memberInfoVo = new MemberInfoVo();
        memberInfoVo.setId(1);
        memberInfoVo.setName("张三");
        memberInfoVo.setSex(SEX_MAN);
        memberInfoVo.setCardNumber("123456789");
        memberInfoVo.setBirthday(sdf.parse("1988-01-01"));
        memberInfoVo.setIdNumber("421000000000000000");
        memberInfoVo.setCertificateAddress("皇后大道");
        memberInfoVo.setEmail("xxxxx@xxx.com");
        memberInfoVo.setWx("13312341234");
        memberInfoVo.setMemberType((byte) 0);
        memberInfoVo.setTelephone("0769-22223333");
        memberInfoVo.setMobilePhone("13312341234");
        memberInfoVo.setAddress("皇后大道东");
        memberInfoVo.setWorkplace("皇后大道西");
        memberInfoVo.setJob("test");
        memberInfoVo.setInviter("nothing");
        memberInfoVo.setProfession("test");
        memberInfoVo.setPayType((byte) 0);
        memberInfoVo.setMemberSignatureDate(new Date());
        memberInfoVo.setManager("XXX");
        memberInfoVo.setManagerSignatureDate(new Date());
//        memberInfoVo.setCreateDate(new Date());
        memberInfoVo.setCreateUserId(1);
        memberInfoVo.setCreateUserName("admin");
        memberInfoVo.setState((byte) 1);

        List<MemberFamilyInfoVo> family = new ArrayList<>();
        MemberFamilyInfoVo father = new MemberFamilyInfoVo();
        father.setName("张二");
        father.setRelationship("父子");
        family.add(father);
        MemberFamilyInfoVo mother = new MemberFamilyInfoVo();
        mother.setName("李二");
        mother.setRelationship("母子");
        family.add(mother);

        memberInfoVo.setFamily(family);

    }

    @Test
    public void t_001_insert() {
        BaseResponse response = controller.insert(memberInfoVo);
        Assert.assertEquals(200, response.getStatus());
    }

    @Test
    public void t_002_get() {
        ObjectRestResponse<MemberInfoVo> response = controller.get(memberInfoVo.getId());
        Assert.assertEquals(200, response.getStatus());
        Assert.assertNotNull(response.getData());
        Assert.assertEquals("张三", response.getData().getName());
    }



    @Test
    public void t_003_update() {
        String eMail = "test@qq.com";
        MemberInfoVo member = controller.get(memberInfoVo.getId()).getData();
        List<MemberFamilyInfoVo> family = member.getFamily();
        MemberFamilyInfoVo family1 = family.get(0);
        family1.setId(null);
        family1.setName("大熊");
        family1.setRelationship("兄弟");
        MemberFamilyInfoVo family2 = family.get(1);
        family2.setName("熊二");
        family2.setRelationship("兄弟");
        member.setEmail(eMail);
        BaseResponse response = controller.update(member);
        Assert.assertEquals(200, response.getStatus());
        ObjectRestResponse<MemberInfoVo> resp = controller.get(memberInfoVo.getId());
        Assert.assertEquals(eMail, resp.getData().getEmail());

        List<MemberFamilyInfoVo> familyInfos = resp.getData().getFamily();
        for (MemberFamilyInfoVo info : familyInfos) {
            Assert.assertTrue(family1.getName().equals(info.getName())
                    || family2.getName().equals(info.getName()));
        }

    }

    @Test
    public void t_004_getAll() {
        TableResultResponse<MemberInfoVo> response = controller.getAll(1, 10);
        Assert.assertEquals(200, response.getStatus());
        Assert.assertTrue(response.getData().getRows().size() > 0);
    }

    @Test
    public void t_005_delete() {
        BaseResponse response = controller.delete(memberInfoVo.getId());
        Assert.assertEquals(200, response.getStatus());
    }
}