package com.xxfc.member.vo;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

@Data
public class MemberInfoVo {

    private Integer id;

    /**
     * 姓名
     */
    private String name;

    /**
     * 性别(0:男,1:女)
     */
    private Boolean sex;

    /**
     * 卡号
     */
    private String cardNumber;

    /**
     * 生日
     */
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date birthday;

    /**
     * 身份证号
     */
    private String idNumber;

    /**
     * 证件地址
     */
    private String certificateAddress;

    /**
     * 电子邮件
     */
    private String email;

    /**
     * 微信
     */
    private String wx;

    /**
     * 会员类型(0:会员,1:VIP会员,2:砖石会员)
     */
    private Byte memberType;

    /**
     * 联系电话
     */
    private String telephone;

    /**
     * 手机
     */
    private String mobilePhone;

    /**
     * 常住地址
     */
    private String address;

    /**
     * 工作单位
     */
    private String workplace;

    /**
     * 职务
     */
    private String job;

    /**
     * 邀约人
     */
    private String inviter;

    /**
     * 职业
     */
    private String profession;

    /**
     * 支付方式(0:现金,1:刷卡,2:微信支付,3:支付宝支付,4:银行转账)
     */
    private Byte payType;

    /**
     * 会员签名日期
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date memberSignatureDate;

    /**
     * 经理
     */
    private String manager;

    /**
     * 经理签名日期
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date managerSignatureDate;

    /**
     * 创建日期
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createDate;

    /**
     * 创建人用户id
     */
    private Integer createUserId;

    /**
     * 创建人姓名
     */
    private String createUserName;

    /**
     * 会员状态(-1:停用,0:未审核,1:正常)
     */
    private Byte state;

    private List<MemberFamilyInfoVo> family;

    public List<MemberFamilyInfoVo> getFamily() {
        return family;
    }

    public void setFamily(List<MemberFamilyInfoVo> family) {
        this.family = family;
    }
}
