<?php
//dezend by http://www.yunlu99.com/
class WXBizDataCrypt
{
	private $appid;
	private $sessionKey;

	public function __construct($appid, $sessionKey)
	{
		$this->sessionKey = $sessionKey;
		$this->appid = $appid;
	}

	public function decryptData($encryptedData, $iv, &$data)
	{
		if (strlen($this->sessionKey) != 24) {
			return ErrorCode::$IllegalAesKey;
		}

		$aesKey = base64_decode($this->sessionKey);

		if (strlen($iv) != 24) {
			return ErrorCode::$IllegalIv;
		}

		$aesIV = base64_decode($iv);
		$aesCipher = base64_decode($encryptedData);
		$result = openssl_decrypt($aesCipher, 'AES-128-CBC', $aesKey, 1, $aesIV);
		$dataObj = json_decode($result);

		if ($dataObj == NULL) {
			return ErrorCode::$IllegalBuffer;
		}

		if ($dataObj->watermark->appid != $this->appid) {
			return ErrorCode::$IllegalBuffer;
		}

		$data = $result;
		return ErrorCode::$OK;
	}
}

include_once 'errorCode.php';

?>
